﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ige/ige_HtcsHelper.h>

#ifndef NN_BUILD_CONFIG_SPEC_CAFE

#include <nn/htcs.h>

namespace nn { namespace ige {

int HtcsHelperSocket() NN_NOEXCEPT
{
    return nn::htcs::Socket();
}

int HtcsHelperClose(int descriptor) NN_NOEXCEPT
{
    return nn::htcs::Close(descriptor);
}

int HtcsHelperConnect(int descriptor, const htcs::SockAddrHtcs* address) NN_NOEXCEPT
{
    return nn::htcs::Connect(descriptor, address);
}

int HtcsHelperBind(int descriptor, const htcs::SockAddrHtcs* address) NN_NOEXCEPT
{
    return nn::htcs::Bind(descriptor, address);
}

int HtcsHelperListen(int descriptor, int backlogCount) NN_NOEXCEPT
{
    return nn::htcs::Listen(descriptor, backlogCount);
}

int HtcsHelperAccept(int descriptor, htcs::SockAddrHtcs* address) NN_NOEXCEPT
{
    return nn::htcs::Accept(descriptor, address);
}

htcs::ssize_t HtcsHelperRecv(int descriptor, void* buffer, size_t bufferByteSize, int flags) NN_NOEXCEPT
{
    return nn::htcs::Recv(descriptor, buffer, bufferByteSize, flags);
}

htcs::ssize_t HtcsHelperSend(int descriptor, const void* buffer, size_t bufferByteSize, int flags) NN_NOEXCEPT
{
    return nn::htcs::Send(descriptor, buffer, bufferByteSize, flags);
}

int HtcsHelperShutdown(int descriptor, int how) NN_NOEXCEPT
{
    return nn::htcs::Shutdown(descriptor, how);
}

int HtcsHelperFcntl(int descriptor, int command, int value) NN_NOEXCEPT
{
    return nn::htcs::Fcntl(descriptor, command, value);
}

int HtcsHelperGetLastError() NN_NOEXCEPT
{
    return nn::htcs::GetLastError();
}

const htcs::HtcsPeerName HtcsHelperGetPeerNameAny() NN_NOEXCEPT
{
    return nn::htcs::GetPeerNameAny();
}

const htcs::HtcsPeerName HtcsHelperGetDefaultHostName() NN_NOEXCEPT
{
    return nn::htcs::GetDefaultHostName();
}

}}

#endif
