﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ige_BufferReader.h"

namespace nn { namespace ige { namespace detail {

template<> void BufferReader::Read<bool>(bool* ptr) NN_NOEXCEPT
{
    *ptr = ReadBool();
}

template<> void BufferReader::Read<uint8_t>(uint8_t* ptr) NN_NOEXCEPT
{
    *ptr = ReadUInt8();
}

template<> void BufferReader::Read<int8_t>(int8_t* ptr) NN_NOEXCEPT
{
    *ptr = ReadInt8();
}

}}}
