﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include "ige_ServerSocket.h"

namespace nn { namespace ige { namespace detail {

ServerSocket::ServerSocket() NN_NOEXCEPT
    : m_pWriteBuffer(NULL)
    , m_pReadBuffer(NULL)
    , m_WriteBufferSize(0)
    , m_WriteSizeRemained(0)
    , m_ReadBufferSize(0)
    , m_ReadSizeRemained(0)
    , m_IsOpenRequested(false)
    , m_IsOpened(false)
    , m_IsWriteLogEnabled(false)
{
}

bool ServerSocket::Write(const void* buf, size_t size) NN_NOEXCEPT
{
    if (!WriteAsync(buf, size))
    {
        ResetWriteFlag();
        return false;
    }

    while (IsWriting())
    {
        if (!IsConnected())
        {
            return false;
        }

        if (!WriteAsyncForPoll())
        {
            return false;
        }
    }

    ResetWriteFlag();
    return true;
}

bool ServerSocket::WriteAsync(const void* buf, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(buf);
    NN_SDK_REQUIRES(size != 0);

    return WriteAsyncInternal(buf, size);
}

bool ServerSocket::Read(void* buf, size_t size) NN_NOEXCEPT
{
    if (!ReadAsync(buf, size))
    {
        ResetReadFlag();
        return false;
    }

    while (IsReading())
    {
        if (!IsConnected())
        {
            return false;
        }

        if (!ReadAsyncForPoll())
        {
            return false;
        }
    }

    ResetReadFlag();
    return true;
}

bool ServerSocket::ReadAsync(void* buf, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(buf);
    NN_SDK_REQUIRES(size != 0);

    return ReadAsyncInternal(buf, size);
}

}}} // namespace nn::ige::detail
