﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>


#include "../util/g3d_FixedSizeArray.h"
#include "g3d_EditRenderInfoObj.h"
#include "g3d_EditBlinkingObj.h"
#include "../util/g3d_EditWorkBufferSwitcher.h"

#include <nn/g3d/g3d_ResMaterial.h>
#include <nn/g3d/g3d_MaterialObj.h>
#include <nn/gfx/gfx_Core.h>
#include <nn/gfx/gfx_Types.h>
#include <nn/gfx/gfx_Sampler.h>
#include <nn/gfx/gfx_MemoryPool.h>

namespace nn { namespace g3d {

class ModelObj;

namespace viewer {

namespace detail {

class EditModelObj;
class EditSampler;
class Allocator;
class CallbackCaller;

class EditMaterialObj : public BlinkingObj
{
public:
    explicit EditMaterialObj(
        nn::gfx::Device* pDevice,
        Allocator* pAllocator,
        int index,
        nn::g3d::ModelObj* pOwnerModelObj,
        nn::g3d::MaterialObj* pMaterialObj) NN_NOEXCEPT;
    ~EditMaterialObj() NN_NOEXCEPT;

    void ResetToOriginal() NN_NOEXCEPT;
    void UpdateRenderInfo(
        const void* pRenderInfoUpdateCommandData, size_t renderInfoUpdateCommandDataSize,
        ptrdiff_t renderInfoArrayOffset) NN_NOEXCEPT;

    bool GetMaterialVisibilityEnabled() const NN_NOEXCEPT
    {
        return m_MaterialVisibilityEnable;
    }

    bool ReinitBuffer(const nn::g3d::ResMaterial* pResMaterial) NN_NOEXCEPT;
    size_t CalculateBlockBufferSize(const nn::g3d::ResMaterial* pResMaterial) const NN_NOEXCEPT;
    size_t GetBlockBufferAlignment(const nn::g3d::ResMaterial* pResMaterial) const NN_NOEXCEPT;
    void SetupMaterialInstance(
        nn::g3d::ResMaterial* pResMaterial,
        nn::gfx::MemoryPool* pMemoryPool,
        ptrdiff_t memoryPoolOffset,
        size_t memoryPoolSize) NN_NOEXCEPT;

    template<typename TValue>
    void EditShaderParam(
        const char* paramName,
        ResShaderParam::Type paramType,
        const TValue* pValues,
        int valueCount) NN_NOEXCEPT
    {
        int paramIndex = m_pMaterialObj->FindShaderParamIndex(paramName);
        if (paramIndex == -1)
        {
            return;
        }

        NN_G3D_VIEWER_ASSERT_INDEX_BOUNDS(paramIndex, m_pMaterialObj->GetShaderParamCount());

        // この判定で良いかはあとで考える
        const ResShaderParam* pResShaderParam = m_pMaterialObj->GetResShaderParam(paramIndex);
        if (pResShaderParam->GetType() != paramType)
        {
            return;
        }

        TValue* pEditValue = m_pMaterialObj->EditShaderParam<TValue>(paramIndex);
        TValue* pEditValueBackup = AddOffset<TValue>(m_pEditedSrcParam, pResShaderParam->GetSrcOffset());
        for (int idxValue = 0; idxValue < valueCount; ++idxValue)
        {
            pEditValue[idxValue] = pValues[idxValue];
            pEditValueBackup[idxValue] = pValues[idxValue];
        }

        m_ShaderParamEditFlags.Set(paramIndex);
    }

    void EditTextureSrt(
        const char* paramName,
        TexSrt::Mode mode,
        ResShaderParam::Type paramType,
        const float* pValues,
        int valueCount) NN_NOEXCEPT;

    // 3DEditorから編集されたシェーダパラメータの状態を再現します。
    void RestoreEditedShaderParam() NN_NOEXCEPT;

    bool ExaminesTextureFileUsed(const nn::gfx::ResTextureFile* pResTextureFile) const NN_NOEXCEPT;

    void SetMaterialVisible(bool visible) NN_NOEXCEPT;
    void UpdateMaterialVisible() NN_NOEXCEPT;

    void SwitchBlockBuffer() NN_NOEXCEPT;

private:
    virtual void Show() NN_NOEXCEPT;
    virtual void Hide() NN_NOEXCEPT;
    virtual bool IsVisibleByDefault() const NN_NOEXCEPT;
    void ReinitEditedShaderParam(const nn::g3d::ResMaterial* pResMaterial) NN_NOEXCEPT;

    int m_Index;
    nn::g3d::ModelObj*          m_pOwnerModel;
    nn::g3d::MaterialObj*       m_pMaterialObj;
    nn::g3d::ResMaterial*       m_pOriginalMaterial;

    void*                       m_pOriginalBuffer;
    size_t                      m_OriginalBufferSize;
    int                         m_OriginalBufferingCount;

    nn::gfx::MemoryPool*        m_pOriginalBlockMemoryPool;
    ptrdiff_t                   m_OriginalBlockMemoryPoolOffset;
    size_t                      m_OriginalBlockBufferSize;
    nn::gfx::Buffer* m_pOriginalBlockBufferArray;

    EditWorkBuffer              m_WorkBuffer;
    EditWorkBufferSwitcher m_BlockBufferObjectManager;

    EditRenderInfoObj           m_RenderInfo;

    bool m_MaterialVisibilityEnable;
    DynamicArray<nn::g3d::TextureRef> m_TextureRefArray;

    // マテリアルアニメーションが適用されると消えてしまうシェーダパラメータの編集状態を保持しておくためのバッファ。
    // リソースの更新が入った時、このバッファは更新されたリソースの値と一致しているはずなので
    // リソースのバッファと値を同期する必要はないはず
    void* m_pEditedSrcParam;
    size_t m_EditedSrcParamSize;

    FlagSet m_ShaderParamEditFlags;
    void* m_pShaderParamEditFlagBuffer;

private:
    NN_DISALLOW_COPY(EditMaterialObj);
};

}}}}


