﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>

#include <nn/g3d/g3d_Assert.h>
#include <nn/nn_SdkText.h>

typedef int ViewerKeyType;

namespace nn { namespace g3d { namespace viewer { namespace detail {

    enum
    {
        InvalidKey = 0,

        // トリプルバッファリングで 1 フレームに最大 2 回更新が入る想定としておく
        BufferingCountMax = 3, //!< コマンドバッファーの想定最大バッファリング数
        RebuildModelObjCountMaxPerFrame = 2, //!< 1 フレームで ModelObj がリビルドされる想定最大回数
        UniformBlockBufferingCount = BufferingCountMax * RebuildModelObjCountMaxPerFrame, //!< ユニフォームブロックのバッファリング数
    };

    bool IsRuntimeDebugLogEnabled() NN_NOEXCEPT;

}}}}

#if defined(NN_SDK_BUILD_DEBUG)
#define NN_G3D_VIEWER_LOG( ... ) NN_DETAIL_STRUCTURED_SDK_LOG(g3dviewer, Info, 0, ##__VA_ARGS__)
#else
#define NN_G3D_VIEWER_LOG( ... ) static_cast<void>(0)
#endif

// ランタイムエラーが発生して 3DEditor と通信を切断する場合などにエラー原因を通知するため
#define NN_G3D_VIEWER_ERROR_LOG( ... ) NN_DETAIL_STRUCTURED_SDK_LOG(g3dviewer, Error, 0, ##__VA_ARGS__)

#define NN_G3D_VIEWER_WARNING_LOG( ... ) NN_DETAIL_STRUCTURED_SDK_LOG(g3dviewer, Warn, 0, ##__VA_ARGS__)

// 内部実装の警告用マクロ
#if defined(NN_SDK_BUILD_DEBUG) | defined(NN_SDK_BUILD_DEVELOP)
#define NN_G3D_VIEWER_INTERNAL_WARNING( ... ) NN_G3D_VIEWER_WARNING_LOG("Internal Warning: " __VA_ARGS__)
#else
#define NN_G3D_VIEWER_INTERNAL_WARNING( ... ) static_cast<void>(0)
#endif

#define NN_G3D_VIEWER_REQUIRES_NOT_NULL_DETAIL(ptr, name) \
    NN_SDK_REQUIRES(ptr != nullptr, "Resource name : %s\n", name)

#define NN_G3D_VIEWER_REQUIRES_NOT_NULL(ptr) \
    NN_SDK_REQUIRES(ptr != nullptr)

#define NN_G3D_VIEWER_REQUIRES_RANGE(value, min, max) \
    NN_UNUSED(value); NN_SDK_REQUIRES(min <= value && value < max);

#define NN_G3D_VIEWER_REQUIRES(exp) \
    NN_SDK_REQUIRES(exp)

#define NN_G3D_VIEWER_ASSERT(condition) \
    NN_UNUSED(condition); NN_SDK_ASSERT(condition)

#define NN_G3D_VIEWER_ASSERT_DETAIL(condition, ...)\
    NN_UNUSED(condition); NN_SDK_ASSERT(condition, __VA_ARGS__)

#define NN_G3D_VIEWER_ASSERT_NOT_NULL(ptr) \
    NN_G3D_VIEWER_ASSERT(ptr != nullptr)

#define NN_G3D_VIEWER_ASSERT_NOT_NULL_DETAIL(ptr, ...) \
    NN_G3D_VIEWER_ASSERT_DETAIL(ptr != nullptr, __VA_ARGS__)

#define NN_G3D_VIEWER_ASSERT_INDEX_BOUNDS(index, count) \
    NN_G3D_VIEWER_ASSERT(index >= 0 && index < count)

#define NN_G3D_VIEWER_ASSERT_EQUAL(lhs, rhs) \
    NN_UNUSED(lhs); NN_UNUSED(rhs); NN_SDK_ASSERT_EQUAL(lhs, rhs)

#define NN_G3D_VIEWER_ASSERT_VALID_KEY(key) \
    NN_UNUSED(key); NN_SDK_ASSERT(key != nn::g3d::viewer::detail::InvalidKey)

#define NN_G3D_VIEWER_RES_NAME(res, nameFunc) \
    res->nameFunc


#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
#define NN_DETAIL_G3D_VIEWER_CONFIG_DEBUG_LOG_ENABLED (1)
#else
#define NN_DETAIL_G3D_VIEWER_CONFIG_DEBUG_LOG_ENABLED (0)
#endif

#if NN_DETAIL_G3D_VIEWER_CONFIG_DEBUG_LOG_ENABLED
#define NN_G3D_VIEWER_DEBUG_PRINT( ... ) \
    if (nn::g3d::viewer::detail::IsRuntimeDebugLogEnabled()) { NN_DETAIL_STRUCTURED_SDK_LOG(g3dviewer, Info, 0, "Debug: " __VA_ARGS__); }
#else
#define NN_G3D_VIEWER_DEBUG_PRINT( ... ) static_cast<void>(0)
#endif
