﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>



#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>
#include "g3d_EditSocket.h"
#include "g3d_Allocator.h"

namespace nn {
namespace g3d {
namespace viewer {
namespace detail {

class PingMonitor
{
    NN_DISALLOW_COPY(PingMonitor);

public:
    explicit PingMonitor(Allocator* pAllocator) NN_NOEXCEPT;
    ~PingMonitor() NN_NOEXCEPT;

    ViewerResult Initialize(int codePage) NN_NOEXCEPT;

    bool RequestOpen() NN_NOEXCEPT;
    void Close() NN_NOEXCEPT;

    bool IsOpened() const NN_NOEXCEPT
    {
        return m_pPingSocket->IsOpened();
    }

    bool IsOpenRequested() const NN_NOEXCEPT
    {
        return m_pPingSocket->IsOpenRequested();
    }

    //! @brief クローズ中かどうかを取得します。
    //!        3DEditor へのクローズ通知を行っている間は true を返します。
    bool IsClosing() const NN_NOEXCEPT
    {
        return m_IsCloseRequested || m_IsClosing;
    }

    bool IsConnected() const NN_NOEXCEPT
    {
        return m_pPingSocket->IsConnected();
    }

    void Poll() NN_NOEXCEPT;
    void BeginFreeze(bool sync) NN_NOEXCEPT
    {
        m_IsBeginFreezeEnabled = true;

        if (sync)
        {
            m_SendPingPacket.block.state = PingState_Lock;
            m_IsCommSyncEnabled = true;
        }
        else
        {
            m_SendPingPacket.block.state = PingState_Normal;
            m_IsCommSyncEnabled = false;
        }
    }

    void EndFreeze() NN_NOEXCEPT
    {
        m_IsBeginFreezeEnabled = false;
        m_SendPingPacket.block.state = PingState_Unlock;
    }

    void SetRuntimeStateToNormal() NN_NOEXCEPT
    {
        m_SendPingPacket.block.state = PingState_Normal;
    }

    void RequestClose() NN_NOEXCEPT
    {
        m_IsCloseRequested = true;
    }

    bool IsFreezing() const NN_NOEXCEPT
    {
        return m_IsBeginFreezeEnabled;
    }

    void ClearState() NN_NOEXCEPT;

private:
    void AnalyzePingPacket() NN_NOEXCEPT;

    Allocator* m_pAllocator;
    nn::g3d::viewer::detail::EditSocketBase* m_pPingSocket;
    nn::g3d::viewer::detail::PingPacket m_RecvPingPacket;
    nn::g3d::viewer::detail::PingPacket m_SendPingPacket;

    volatile bool m_IsBeginFreezeEnabled;
    volatile bool m_IsCommSyncEnabled; //通信処理同期フラグ

    volatile bool m_IsReadStarted;
    volatile bool m_IsWriteStarted;
    volatile bool m_IsWritePingSucceeded;
    volatile bool m_IsCloseRequested;
    volatile bool m_IsClosing;
};

}}}} // namespace nn::g3d::viewer::detail


