﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>
#include <nn/g3d/viewer/g3d_ViewerCallback.h>
#include <nn/g3d/g3d_ResFile.h>

namespace nn { namespace g3d { namespace viewer { namespace detail {

class CallbackCaller
{
public:
    CallbackCaller(
        const ViewerCallback callbackFunction,
        void* pCallbackUserData,
        const ViewerTextureBindCallback textureBindCallback,
        void* pTextureBindCallbackUserData) NN_NOEXCEPT
        : m_CallbackFunction(callbackFunction)
        , m_pCallbackUserData(pCallbackUserData)
        , m_TextureBindCallback(textureBindCallback)
        , m_pTextureBindCallbackUserData(pTextureBindCallbackUserData)
    {
    }

    NN_FORCEINLINE void Call(void* pOutArg, const void* pInArg, CallbackType type) NN_NOEXCEPT
    {
        if (m_CallbackFunction == nullptr)
        {
            return;
        }

        return m_CallbackFunction(pOutArg, pInArg, type, m_pCallbackUserData);
    }

    NN_FORCEINLINE void Call(CallbackType type, const void* pInArg) NN_NOEXCEPT
    {
        if (m_CallbackFunction == nullptr)
        {
            return;
        }

        return m_CallbackFunction(nullptr, pInArg, type, m_pCallbackUserData);
    }

    NN_FORCEINLINE nn::g3d::TextureRef CallTextureBindCallback(const char* name, const nn::gfx::ResTextureFile* pResTextureFile) NN_NOEXCEPT
    {
        return m_TextureBindCallback(name, pResTextureFile, m_pTextureBindCallbackUserData);
    }

private:
    const ViewerCallback m_CallbackFunction;
    void* m_pCallbackUserData;
    const ViewerTextureBindCallback m_TextureBindCallback;
    void* m_pTextureBindCallbackUserData;
};

}}}} // namespace nn::g3d::viewer::detail

