﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../g3d_ViewerDetailDefine.h"
#include "g3d_IViewerCommand.h"
#include "g3d_CommandTypes.h"
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>
#include <nn/util/util_Vector.h>

namespace nn { namespace g3d { namespace viewer { namespace detail {
    class LayoutModelCommand : public IViewerCommand
    {
    public:
        LayoutModelCommand(
            ViewerKeyType modelKey,
            const nn::util::Vector3fType& scale,
            const nn::util::Vector3fType& rotate,
            const nn::util::Vector3fType& translate) NN_NOEXCEPT;
        ~LayoutModelCommand() NN_NOEXCEPT;

        virtual int Type() const NN_NOEXCEPT
        {
            return CommandType_LayoutModel;
        }

        virtual CommandResult Execute(EditSocketBase* pSocket) NN_NOEXCEPT;

    private:
        ModelLayoutEditPacket m_ModelLayoutPacket;
    };
}}}}
