﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditSkeletalAnimObj.h"

namespace {
    void ClearLocalMtx(nn::g3d::ModelObj* pModelObj, void*) NN_NOEXCEPT
    {
        pModelObj->GetSkeleton()->ClearLocalMtx();
    }
}

namespace nn { namespace g3d { namespace viewer { namespace detail {

/*virtual*/void
EditSkeletalAnimObj::ResetToOriginalValue(EditModelObj* pBoundEditModelObj) NN_NOEXCEPT
{
    if (!IsModelBound(pBoundEditModelObj))
    {
        return;
    }

    pBoundEditModelObj->ExecuteFunctionForeachInstance(ClearLocalMtx);
}

/*virtual*/bool
EditSkeletalAnimObj::CreateDataForEditingAnimCurve() NN_NOEXCEPT
{
    return true;
}

/*virtual*/void
EditSkeletalAnimObj::DestroyDataForEditingAnimCurve() NN_NOEXCEPT
{
}

/*virtual*/BindResult
EditSkeletalAnimObj::SetupInternal(EditModelObj* pBindTargetEditModelObj, ModelAnimObj* pBoundAnimObj) NN_NOEXCEPT
{
    BindResult result;
    const ResModel* pResModel = pBindTargetEditModelObj->GetResource();
    SkeletalAnimObj* pAnimObj = static_cast<SkeletalAnimObj*>(pBoundAnimObj);
    ResSkeletalAnim* pResSkeletalAnim = static_cast<ResSkeletalAnim*>(GetResAnim());

    SkeletalAnimObj::Builder builder;
    builder.SetContextDisabled();
    builder.Reserve(pResModel);
    builder.Reserve(pResSkeletalAnim);
    builder.SetRetargetingEnabled();

    builder.CalculateMemorySize();
    size_t bufferSize = builder.GetWorkMemorySize();
    void* buffer = m_pAllocator->Allocate(bufferSize, SkeletalAnimObj::Alignment_Buffer, AllocateType_Obj);
    NN_G3D_VIEWER_ASSERT_NOT_NULL_DETAIL(buffer, "%s\n", NN_G3D_VIEWER_RES_NAME(pResModel, GetName()));//今は止める
    bool success = builder.Build(pAnimObj, buffer, bufferSize);
    NN_G3D_VIEWER_ASSERT(success);
    pAnimObj->SetResource(pResSkeletalAnim);

    if (m_pRetargetingHostModel != nullptr)
    {
        nn::g3d::SkeletalAnimObj::BindArgument bindArg;
        bindArg.SetResource(pBindTargetEditModelObj->GetResource()->GetSkeleton());
        bindArg.SetHostResource(m_pRetargetingHostModel->GetResource()->GetSkeleton());
        bindArg.SetRetargetingEnabled();
        result = pAnimObj->Bind(bindArg);
    }
    else
    {
        result = pAnimObj->Bind(pBindTargetEditModelObj->GetResource());
    }

    return result;
}

}}}}

