﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/viewer/detail/hio/atk_HioStream.h>

#ifdef NN_ATK_CONFIG_ENABLE_DEV

namespace nn {
namespace atk {
namespace viewer {
namespace detail {

//----------------------------------------------------------
HioStream::HioStream() NN_NOEXCEPT
{
}

//----------------------------------------------------------
void
HioStream::Initialize(void* workBuffer, size_t workBufferLength) NN_NOEXCEPT
{
    m_Stream.Initialize(workBuffer, workBufferLength);
}

//----------------------------------------------------------
void
HioStream::Finalize() NN_NOEXCEPT
{
    m_Stream.Finalize();
}

//----------------------------------------------------------
bool
HioStream::Open(ChannelType channel, void* buffer, size_t length) NN_NOEXCEPT
{
    return m_Stream.Open(channel, buffer, length);
}

//----------------------------------------------------------
void
HioStream::Close() NN_NOEXCEPT
{
    m_Stream.Close();
}

//----------------------------------------------------------
bool
HioStream::IsAvailable() const NN_NOEXCEPT
{
    return m_Stream.IsOpened();
}

//----------------------------------------------------------
size_t
HioStream::GetReadableBytes() NN_NOEXCEPT
{
    return m_Stream.GetReadableBytes();
}

//----------------------------------------------------------
size_t
HioStream::Read(void* buffer, size_t length) NN_NOEXCEPT
{
    return m_Stream.Read(buffer, length);
}

//----------------------------------------------------------
size_t
HioStream::Skip(size_t length) NN_NOEXCEPT
{
    return m_Stream.Skip(length);
}

//----------------------------------------------------------
size_t
HioStream::Write(const void* buffer, size_t length) NN_NOEXCEPT
{
    return m_Stream.Write(buffer, length);
}

//----------------------------------------------------------
bool
HioStream::Polling() NN_NOEXCEPT
{
    if (!m_Stream.Connect())
    {
        m_Stream.Disconnect();
        return false;
    }

    return true;
}

} // namespace nn::atk::viewer::detail
} // namespace nn::atk::viewer
} // namespace nn::atk
} // namespace nn

#endif // NN_ATK_CONFIG_ENABLE_DEV
