﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/viewer/detail/handler/atk_PlaySoundHandler.h>

#ifdef NN_ATK_CONFIG_ENABLE_DEV

#include <nn/atk/viewer/atk_SoundObjectController.h>
#include <nn/atk/viewer/detail/atk_SoundControllerImpl.h>

namespace nn {
namespace atk {
namespace viewer {
namespace detail {

//----------------------------------------------------------
void
PlaySoundHandler::SetSoundObjectController(SoundObjectController* soundObjectController) NN_NOEXCEPT
{
    m_SoundObjectController = soundObjectController;
}

//----------------------------------------------------------
viewer::detail::HioResult
PlaySoundHandler::OnInvokeForReadTargetPacket(
    const PlaySoundPacket& packet,
    viewer::detail::HioPacketStream& /*stream*/) NN_NOEXCEPT
{
    if(m_SoundObjectController == NULL)
    {
        return viewer::detail::HioResult(viewer::detail::HioResultType_False);
    }

    if(packet.GetBody().GetItemNameLength() == 0)
    {
        return viewer::detail::HioResult(viewer::detail::HioResultType_True);
    }

    SoundControllerImpl* controller =
        reinterpret_cast<SoundControllerImpl*>(
        m_SoundObjectController->GetSoundController(packet.GetBody().GetSoundHandleIndex())
        );

    if(controller == NULL)
    {
        return viewer::detail::HioResult(viewer::detail::HioResultType_True);
    }

    if(controller->SetLabel(packet.GetBody().GetItemName()).IsFailed())
    {
        return viewer::detail::HioResult(viewer::detail::HioResultType_True);
    }

    controller->Play();

    return viewer::detail::HioResult(viewer::detail::HioResultType_True);
}

} // namespace nn::atk::viewer::detail
} // namespace nn::atk::viewer
} // namespace nn::atk
} // namespace nn

#endif // NN_ATK_CONFIG_ENABLE_DEV
