﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/fnd/basis/atkfnd_WorkBufferAllocator.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace atk { namespace detail { namespace fnd {

WorkBufferAllocator::WorkBufferAllocator(void * buffer, size_t size) NN_NOEXCEPT
    : m_Buffer(reinterpret_cast<uintptr_t>(buffer))
    , m_Offset(0)
    , m_Size(size)
{
    NN_SDK_ASSERT_NOT_NULL(buffer);
}

WorkBufferAllocator::WorkBufferAllocator(void * buffer, size_t size, size_t requiredAlignment) NN_NOEXCEPT
    : m_Buffer(reinterpret_cast<uintptr_t>(buffer))
    , m_Offset(0)
    , m_Size(size)
{
    NN_UNUSED(requiredAlignment);
    NN_SDK_ASSERT_NOT_NULL(buffer);
    NN_SDK_ASSERT(nn::util::ispow2(requiredAlignment));
    NN_SDK_ASSERT_ALIGNED(buffer, requiredAlignment);
}

void* WorkBufferAllocator::Allocate(size_t size) NN_NOEXCEPT
{
    return Allocate(size, 1);
}

void* WorkBufferAllocator::Allocate(size_t size, size_t alignment) NN_NOEXCEPT
{
    NN_SDK_ASSERT(nn::util::ispow2(alignment));

    if(size == 0)
    {
        return nullptr;
    }

    const auto Result = nn::util::align_up(m_Buffer + m_Offset, alignment);
    const auto ResultEnd = Result + size;
    const auto WorkBufferEnd = m_Buffer + m_Size;
    NN_SDK_ASSERT_LESS_EQUAL(ResultEnd, WorkBufferEnd);

    if(ResultEnd > WorkBufferEnd)
    {
        return nullptr;
    }

    m_Offset = ResultEnd - m_Buffer;
    return reinterpret_cast<void*>(Result);
}

void * WorkBufferAllocator::Allocate(size_t size, size_t alignment, int count) NN_NOEXCEPT
{
    NN_SDK_ASSERT_GREATER(count, 0);
    NN_SDK_ASSERT(nn::util::ispow2(alignment));
    void* result = Allocate(size, alignment);
    for(int i = 1; i < count; ++i)
    {
        Allocate(size, alignment);
    }
    return result;
}

}}}}
