﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_StreamSoundPrefetchFile.h>
#include <nn/atk/atk_ElementType.h>

namespace nn {
namespace atk {
namespace detail {


//
// StreamSoundPrefetchFile::FileHeader
//
const StreamSoundFile::InfoBlock*
StreamSoundPrefetchFile::FileHeader::GetInfoBlock() const NN_NOEXCEPT
{
    return reinterpret_cast<const StreamSoundFile::InfoBlock*>( GetBlock( ElementType_StreamSoundFile_InfoBlock ) );
}
const StreamSoundFile::RegionBlock*
StreamSoundPrefetchFile::FileHeader::GetRegionBlock() const NN_NOEXCEPT
{
    return reinterpret_cast<const StreamSoundFile::RegionBlock*>( GetBlock( ElementType_StreamSoundFile_RegionBlock ) );
}
const StreamSoundPrefetchFile::PrefetchDataBlock*
StreamSoundPrefetchFile::FileHeader::GetPrefetchDataBlock() const NN_NOEXCEPT
{
    return reinterpret_cast<const PrefetchDataBlock*>( GetBlock( ElementType_StreamSoundFile_PrefetchDataBlock ) );
}
uint32_t StreamSoundPrefetchFile::FileHeader::GetPrefetchDataBlockSize() const NN_NOEXCEPT
{
    return GetBlockSize( ElementType_StreamSoundFile_PrefetchDataBlock );
}

bool StreamSoundPrefetchFile::FileHeader::HasRegionBlock() const NN_NOEXCEPT
{
    return (GetBlock( ElementType_StreamSoundFile_RegionBlock ) != nullptr);
}
uint32_t StreamSoundPrefetchFile::FileHeader::GetRegionBlockSize() const NN_NOEXCEPT
{
    return GetBlockSize( ElementType_StreamSoundFile_RegionBlock );
}
uint32_t StreamSoundPrefetchFile::FileHeader::GetRegionBlockOffset() const NN_NOEXCEPT
{
    return GetBlockOffset( ElementType_StreamSoundFile_RegionBlock );
}

//
// StreamSoundPrefetchFile::PrefetchData
//
const StreamSoundPrefetchFile::PrefetchSample*
StreamSoundPrefetchFile::PrefetchData::GetPrefetchSample() const NN_NOEXCEPT
{
    return reinterpret_cast<const PrefetchSample*>(
        util::ConstBytePtr( this, toPrefetchSample.offset ).Get() );
}

//
// StreamSoundPrefetchFile::PrefetchSample
//
const void*
StreamSoundPrefetchFile::PrefetchSample::GetSampleAddress() const NN_NOEXCEPT
{
    return reinterpret_cast<const void*>( data );
}

} // namespace nn::atk::detail
} // namespace nn::atk
} // namespace nn

