﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_DisposeCallbackManager.h>
#include <nn/atk/atk_SoundThread.h>

namespace nn {
namespace atk {
namespace detail {
namespace driver {

/* ========================================================================
        member function
   ======================================================================== */

/*--------------------------------------------------------------------------------*
  Name:         GetInstance

  Description:  シングルトンのインスタンスを取得する

  Arguments:    なし

  Returns:      なし
 *--------------------------------------------------------------------------------*/
DisposeCallbackManager& DisposeCallbackManager::GetInstance() NN_NOEXCEPT
{
    static DisposeCallbackManager instance;
    return instance;
}

/*--------------------------------------------------------------------------------*
  Name:         DisposeCallbackManager

  Description:  コンストラクタ

  Arguments:    なし

  Returns:      なし
 *--------------------------------------------------------------------------------*/
DisposeCallbackManager::DisposeCallbackManager() NN_NOEXCEPT
{
}

/*--------------------------------------------------------------------------------*
  Name:         RegisterDisposeCallback

  Description:  無効化コールバックを登録する

  Arguments:    なし

  Returns:      なし
 *--------------------------------------------------------------------------------*/
void DisposeCallbackManager::RegisterDisposeCallback( DisposeCallback* callback ) NN_NOEXCEPT
{
    m_CallbackList.push_back( *callback );

    // NN_DETAIL_ATK_INFO("regist %d %d\n",nn::os::Thread::GetCurrentId(),m_CallbackList.GetSize());
}

/*--------------------------------------------------------------------------------*
  Name:         UnregisterDisposeCallback

  Description:  無効化コールバックの登録を解除する

  Arguments:    なし

  Returns:      なし
 *--------------------------------------------------------------------------------*/
void DisposeCallbackManager::UnregisterDisposeCallback( DisposeCallback* callback ) NN_NOEXCEPT
{
    m_CallbackList.erase( m_CallbackList.iterator_to(*callback) );

    // NN_DETAIL_ATK_INFO("unregist %d %d\n",nn::os::Thread::GetCurrentId(),m_CallbackList.GetSize());
}

/*--------------------------------------------------------------------------------*
  Name:         GetCallbackCount

  Description:  登録されている無効化コールバック数を取得する

  Arguments:    なし

  Returns:      なし
 *--------------------------------------------------------------------------------*/
unsigned long DisposeCallbackManager::GetCallbackCount() const NN_NOEXCEPT
{
    return m_CallbackList.size();
}

/*--------------------------------------------------------------------------------*
  Name:         Dispose

  Description:  登録されたオブジェクトに対して無効化を行う

  Arguments:    なし

  Returns:      なし
 *--------------------------------------------------------------------------------*/
void DisposeCallbackManager::Dispose( const void* mem, size_t size ) NN_NOEXCEPT
{
    const void* start = mem;
    const void* end = static_cast<const uint8_t*>( mem ) + size;

    for ( CallbackList::iterator itr = GetInstance().m_CallbackList.begin();
          itr != GetInstance().m_CallbackList.end();
        )
    {
        CallbackList::iterator curItr = itr++;
        curItr->InvalidateData( start, end );
    }
}

} // namespace nn::atk::detail::driver
} // namespace nn::atk::detail
} // namespace nn::atk
} // namespace nn

