﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_BusMixVolumePacket.h>

namespace nn { namespace atk { namespace detail {

size_t BusMixVolumePacket::GetRequiredMemSize(int busCount) NN_NOEXCEPT
{
    size_t result = sizeof(bool) * busCount;
    // TODO: メモリアロケーション処理の正式対応
    result = nn::util::align_up(result, 8);
    return result;
}

bool BusMixVolumePacket::Initialize(void * buffer, size_t size, int busCount) NN_NOEXCEPT
{
    NN_UNUSED(size);
    NN_SDK_ASSERT_GREATER_EQUAL(size, GetRequiredMemSize(busCount));
    m_pIsEnabledTable = reinterpret_cast<bool*>(buffer);
    for(int i = 0; i < busCount; ++i)
    {
        m_pIsEnabledTable[i] = false;
    }
    m_BusCount = busCount;
    return true;
}

void BusMixVolumePacket::Finalize() NN_NOEXCEPT
{
    m_pIsEnabledTable = nullptr;
    m_IsUsed = false;
    m_BusCount = 0;
}

void BusMixVolumePacket::Reset() NN_NOEXCEPT
{
    m_BusMixVolume.Initialize();
    m_IsUsed = false;

    for ( int i = 0; i < m_BusCount; ++i)
    {
        m_pIsEnabledTable[i] = false;
    }
}

}}}
