﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      vfx モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_VFX_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_VFX_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_VFX_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_VFX_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_VFX_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_VFX_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_VFX_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_VFX_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_VFX_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_VFX_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_VFX_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_VFX_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_VFX_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_VFX_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_VFX_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_VFX_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_VFX_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_VFX_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_VFX_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_VFX_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(vfx, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_VFX_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Trace, 0, format, args)
#define NN_DETAIL_VFX_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Trace, 1, format, args)
#define NN_DETAIL_VFX_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Trace, 2, format, args)
#define NN_DETAIL_VFX_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Trace, 3, format, args)

#define NN_DETAIL_VFX_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Info, 0, format, args)
#define NN_DETAIL_VFX_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Info, 1, format, args)
#define NN_DETAIL_VFX_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Info, 2, format, args)
#define NN_DETAIL_VFX_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Info, 3, format, args)

#define NN_DETAIL_VFX_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Warn, 0, format, args)
#define NN_DETAIL_VFX_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Warn, 1, format, args)
#define NN_DETAIL_VFX_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Warn, 2, format, args)
#define NN_DETAIL_VFX_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Warn, 3, format, args)

#define NN_DETAIL_VFX_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Error, 0, format, args)
#define NN_DETAIL_VFX_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Error, 1, format, args)
#define NN_DETAIL_VFX_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Error, 2, format, args)
#define NN_DETAIL_VFX_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Error, 3, format, args)

#define NN_DETAIL_VFX_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Fatal, 0, format, args)
#define NN_DETAIL_VFX_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Fatal, 1, format, args)
#define NN_DETAIL_VFX_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Fatal, 2, format, args)
#define NN_DETAIL_VFX_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(vfx, Fatal, 3, format, args)

#define NN_DETAIL_VFX_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Trace, 0, text, length)
#define NN_DETAIL_VFX_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Trace, 1, text, length)
#define NN_DETAIL_VFX_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Trace, 2, text, length)
#define NN_DETAIL_VFX_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Trace, 3, text, length)

#define NN_DETAIL_VFX_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Info, 0, text, length)
#define NN_DETAIL_VFX_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Info, 1, text, length)
#define NN_DETAIL_VFX_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Info, 2, text, length)
#define NN_DETAIL_VFX_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Info, 3, text, length)

#define NN_DETAIL_VFX_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Warn, 0, text, length)
#define NN_DETAIL_VFX_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Warn, 1, text, length)
#define NN_DETAIL_VFX_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Warn, 2, text, length)
#define NN_DETAIL_VFX_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Warn, 3, text, length)

#define NN_DETAIL_VFX_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Error, 0, text, length)
#define NN_DETAIL_VFX_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Error, 1, text, length)
#define NN_DETAIL_VFX_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Error, 2, text, length)
#define NN_DETAIL_VFX_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Error, 3, text, length)

#define NN_DETAIL_VFX_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Fatal, 0, text, length)
#define NN_DETAIL_VFX_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Fatal, 1, text, length)
#define NN_DETAIL_VFX_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Fatal, 2, text, length)
#define NN_DETAIL_VFX_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(vfx, Fatal, 3, text, length)
