﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/spy/spy_Config.h>
#ifdef NN_SPY_CONFIG_ENABLE_DEV

#include <nn/spy/detail/fnd/os/spyfnd_Event.h>

namespace nn {
namespace spy {
namespace detail {
namespace fnd {

//---------------------------------------------------------------------------
inline
Event::Event(bool isManual, bool initialState) NN_NOEXCEPT
{
    OSInitEvent(&m_Event, initialState, isManual ? OS_EVENT_MANUAL : OS_EVENT_AUTO);
}

//---------------------------------------------------------------------------
inline
Event::~Event() NN_NOEXCEPT
{
}

//---------------------------------------------------------------------------
inline
void
Event::Wait() NN_NOEXCEPT
{
    OSWaitEvent(&m_Event);
}

//---------------------------------------------------------------------------
inline
bool
Event::TryWait() NN_NOEXCEPT
{
    return OSWaitEventWithTimeout(&m_Event, 0) == TRUE;
}

//---------------------------------------------------------------------------
inline
void
Event::Set() NN_NOEXCEPT
{
    OSSignalEvent(&m_Event);
}

//---------------------------------------------------------------------------
inline
void
Event::Reset() NN_NOEXCEPT
{
    OSResetEvent(&m_Event);
}

} // namespace nn::spy::detail::fnd
} // namespace nn::spy::detail
} // namespace nn::spy
} // namespace nn

#endif // NN_SPY_CONFIG_ENABLE_DEV
