﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_MessageQueue.h>

#include <nn/atk2/detail/fnd/atk2_Thread.h>
#include <nn/atk2/detail/fnd/atk2_CriticalSection.h>

namespace nn { namespace atk2 {

    class AudioEngine;

namespace detail {

    class AudioFrameUpdater;

    // @brief オーディオフレーム間隔で更新を行うスレッドのクラスです
    class AudioThread : public fnd::Thread::Handler
    {
    public:
        // @brief 関数の処理結果を表す列挙体です
        enum Result
        {
            Result_Success = 0,       //!< 成功です
            Result_FailedToRunThread, //!< スレッドの実行に失敗しました
            Result_ErrorUnknown       //!< 不明なエラーが発生しました
        };

    public:
        // @brief 初期化に使用するパラメータです
        struct InitArg
        {
            int threadPriority;
            int threadCoreNumber;
            int threadAffinityMask;
            int threadUpdateIntervalMSec;
            size_t messageBufferSize;
            size_t threadStackSize;

            void* workBuffer;
            size_t workBufferSize;

            AudioFrameUpdater* _pAudioFrameUpdater;
            AudioEngine* _pAudioEngine;
        };

        struct PlatformInitArg
        {
            void* threadStackBuffer;
            size_t threadStackBufferSize;

            // @brief プラットフォーム固有の作業バッファです。nn::os::ThreadStackAlignment にアラインされている必要があります。
            void* workBuffer;
            size_t workBufferSize;
        };

    public:
        // @brief 初期化パラメータの初期値を取得します
        void GetDefaultInitArg(InitArg& arg, PlatformInitArg& platfromArg) NN_NOEXCEPT;
        // @brief 必要なバッファサイズを取得します
        size_t GetRequiredBufferSize(const InitArg& arg) const NN_NOEXCEPT;
        // @brief 初期化を行います
        Result Initialize(const InitArg& arg, const PlatformInitArg& platformArg) NN_NOEXCEPT;
        // @brief 終了処理を行います
        void Finalize() NN_NOEXCEPT;

        // @brief 必要なプラットフォーム固有のバッファサイズを取得します
        size_t GetRequiredPlatformBufferSize(InitArg& arg, PlatformInitArg& platformArg) NN_NOEXCEPT;

        virtual ~AudioThread() NN_NOEXCEPT NN_OVERRIDE;

    private:
        // 上位 4 ビットがタイプ、下位28ビットがデータ
        enum Message
        {
            Message_Shutdown    = 0x10000000
        };

    private:
        virtual uint32_t Run(void* pParam) NN_NOEXCEPT NN_OVERRIDE;

    private:
        AudioEngine* m_pAudioEngine;
        AudioFrameUpdater* m_pAudioFrameUpdater;
        fnd::Thread m_Thread;

        nn::os::MessageQueueType m_BlockingQueue;
        uintptr_t* m_MsgBuffer;

        int m_ThreadUpdateIntervalMSec;
        bool m_IsInitialized;
    };

}}}

