﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/util/util_IntrusiveList.h>

#include <nn/atk2/detail/fnd/atk2_CriticalSection.h>
#include <nn/atk2/atk2_IAudioFrameUpdate.h>

namespace nn { namespace atk2 { namespace detail {

    // @brief オーディオフレーム間隔で更新処理を行うものの管理を行うクラスです
    class AudioFrameUpdater
    {
    public:
        // @brief 関数の処理結果を表す列挙体です
        enum Result
        {
            Result_Success = 0, //!< 成功です
            Result_ErrorUnknown //!< 不明なエラーが発生しました
        };
    public:
        // @brief 初期化を行います
        Result Initialize() NN_NOEXCEPT;
        // @brief 終了処理を行います
        void Finalize() NN_NOEXCEPT;
        // @brief 更新処理を行います
        Result Update() NN_NOEXCEPT;

        // @brief 更新処理のロックを行います
        void Lock() NN_NOEXCEPT;
        // @brief 更新処理のアンロックを行います
        void Unlock() NN_NOEXCEPT;

        // @brief オーディオフレーム間隔で更新処理を行うものを登録します。
        Result RegisterAudioFrameUpdate(IAudioFrameUpdate* pUpdate) NN_NOEXCEPT;
        // @brief オーディオフレーム間隔で更新処理を行うものを削除します。
        Result UnregisterAudioFrameUpdate(IAudioFrameUpdate* pUpdate) NN_NOEXCEPT;

    private:
        typedef
            util::IntrusiveList<IAudioFrameUpdate, util::IntrusiveListMemberNodeTraits<IAudioFrameUpdate,&IAudioFrameUpdate::m_Link>>
            AudioFrameUpdateList;

    private:
        fnd::CriticalSection m_UpdateCriticalSection;

        AudioFrameUpdateList m_AudioFrameUpdateList;
    };
}}}
