﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Xml;

namespace BackupSaveData
{
    public static class ParseData
    {
        public const int UpToDateVersion = 2;
        public const string ConfigFileName = "config.xml";

        private const string ConfigRootName = "BackupSaveData";

        public static bool CheckUpToDateVersion(string dataDirPath)
        {
            int version = GetVersion(dataDirPath);
            return version == UpToDateVersion;
        }

        public static int GetVersion(string dataDirPath)
        {
            string configFilePath = Path.Combine(dataDirPath, ConfigFileName);
            if(!File.Exists(configFilePath))
            {
                return 0;
            }

#if false
            XmlReader xmlReader = XmlReader.Create(configFilePath);
            while (xmlReader.Read())
            {
                if (xmlReader.NodeType == XmlNodeType.Element)
                {
                    if(xmlReader.LocalName == "version")
                    {
                        string versionString = xmlReader.Value;
                        Console.WriteLine("versionString = {0}", versionString);
                        int version = 0;
                        int.TryParse(versionString, out version);
                        return version;
                    }
                }
            }
#else
            XmlDocument document = new XmlDocument();
            document.Load(configFilePath);

            XmlElement element = document.DocumentElement;

            if (element.Name == "version")
            {
                string versionString = element.InnerText;
                // Console.WriteLine("versionString = {0}", versionString);
                int version = 0;
                int.TryParse(versionString, out version);
                return version;
            }
            else
            {
                XmlNode node = element.SelectSingleNode("//version");
                if(node != null)
                {
                    string versionString = node.InnerText;
                    // Console.WriteLine("versionString = {0}", versionString);
                    int version = 0;
                    int.TryParse(versionString, out version);
                    return version;
                }
            }
#endif

            return 0;
        }

        public static bool CreateConfigXml(string baseDirPath)
        {
            string configXmlPath = Path.Combine(baseDirPath, ConfigFileName);

            XmlDocument xmlDocument = new XmlDocument();

            XmlDeclaration xmlDecl = xmlDocument.CreateXmlDeclaration("1.0", "utf-8", null);
            xmlDocument.AppendChild(xmlDecl);

            XmlElement elem0 = xmlDocument.CreateElement(ConfigRootName);
            xmlDocument.AppendChild(elem0);

            XmlElement elem = xmlDocument.CreateElement("version");
            elem.InnerText = UpToDateVersion.ToString();
            elem0.AppendChild(elem);

            xmlDocument.Save(configXmlPath);

            return false;
        }
    }
}
