﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace BackupSaveData
{
    public static class FileUtil
    {
        public static bool CopyDirecotryResursively(string srcDir, string destDir)
        {
            if (!Directory.Exists(destDir))
            {
                Directory.CreateDirectory(destDir);
                File.SetAttributes(destDir, File.GetAttributes(srcDir));
            }

            foreach (string file in Directory.GetFiles(srcDir))
            {
                File.Copy(file, Path.Combine(destDir, Path.GetFileName(file)), true);
            }

            foreach (string dir in Directory.GetDirectories(srcDir))
            {
                if (!CopyDirecotryResursively(dir, Path.Combine(destDir, Path.GetFileName(dir))))
                {
                    return false;
                }
            }

            return true;
        }

        public static void DeleteDirectory(string path)
        {
            if(!Directory.Exists(path))
            {
                return;
            }
            DirectoryInfo delDir = new DirectoryInfo(path);
            delDir.Delete(true);
        }

        public static string GetTempDirectoryPath()
        {
            string returnPath;
            string tempPath = System.Environment.GetEnvironmentVariable("TEMP", System.EnvironmentVariableTarget.User);
            if (tempPath == null)
            {
                tempPath = System.Environment.GetEnvironmentVariable("TEMP", System.EnvironmentVariableTarget.Machine);
            }
            returnPath = tempPath;
            return returnPath;
        }
    }
}
