﻿namespace Nintendo.SetEnvironmentVariable
{
    using System;
    using System.Windows.Forms;
    using System.Runtime.InteropServices;

    public class Program
    {
        const int HWND_BROADCAST = 0xffff;
        const uint WM_SETTINGCHANGE = 0x001a;

        [DllImport("user32.dll", SetLastError = true, CharSet = CharSet.Auto)]
        static extern bool SendNotifyMessage(IntPtr hWnd, uint Msg, UIntPtr wParam, string lParam);

        // MEMO: 英訳が面倒なので雑な英語にしています
        const string captionStr = "Set user environment variable";

        static void Main(string[] args)
        {
            SetPathEnvironmentVariable();

        }
        static public void SetPathEnvironmentVariable()
        {
            // PATH に Tools\CommandLineTools を追加済みかどうか？のチェック
            const string pathVariableName = "PATH";
            const string pathValue = "%NINTENDO_SDK_ROOT%\\Tools\\CommandLineTools";
            const string noValueString = "No Value";
            var regKey = Microsoft.Win32.Registry.CurrentUser.CreateSubKey("Environment");
            var prevPathValue = regKey.GetValue(pathVariableName, noValueString, Microsoft.Win32.RegistryValueOptions.DoNotExpandEnvironmentNames);
            bool isAlreadySetPath = false;
            foreach (var value in prevPathValue.ToString().Split(';'))
            {
                if (value == pathValue)
                {
                    isAlreadySetPath = true;
                    break;
                }
            }

            // セット済みならすぐ抜ける
            if (isAlreadySetPath)
            {
                MessageBox.Show("[PATH]\n  already set " + pathValue, captionStr);
                return;
            }

            // PATH が REG_EXPAND_SZ でない場合は、いったん PATH を消す
            // (REG_EXPAND_SZ でないと %NINTENDO_SDK_ROOT% が展開されないので)
            if ((string)(prevPathValue) != noValueString && regKey.GetValueKind(pathVariableName) != Microsoft.Win32.RegistryValueKind.ExpandString)
            {
                System.Environment.SetEnvironmentVariable(pathVariableName, null, System.EnvironmentVariableTarget.User);
            }

            // PATH を設定
            var writeValue = string.Empty;
            if ((string)(prevPathValue) == noValueString)
            {
                writeValue = pathValue;
            }
            else
            {
                writeValue = prevPathValue + ";" + pathValue;
            }
            regKey.SetValue(pathVariableName, writeValue, Microsoft.Win32.RegistryValueKind.ExpandString);
            regKey.Close();
            // レジストリを調整した後のメッセージの送り方は、http://stackoverflow.com/a/19705691 を参考にした。
            SendNotifyMessage((IntPtr)HWND_BROADCAST, WM_SETTINGCHANGE, (UIntPtr)0, "Environment");

            var msg = "[PATH]\n  + " + pathValue;
            MessageBox.Show(msg, captionStr);
        }
    }
}
