﻿using System;
using System.Collections.Generic;

namespace SdkEnvironmentCheckerLibrary
{
    /// <summary>
    /// internal な IEnumerable 拡張メソッドを提供します。
    /// </summary>
    internal static class IEnumerableExtentions
    {
        /// <summary>
        /// 列挙子の各要素に対して、指定アクションを実行します。
        /// </summary>
        /// <typeparam name="TSource">列挙される要素の型。</typeparam>
        /// <param name="source">列挙子。</param>
        /// <param name="action">実行するアクション。</param>
        public static void ForEach<TSource>(this IEnumerable<TSource> source, Action<TSource> action)
        {
            if (source == null) throw new ArgumentNullException(nameof(source));
            if (action == null) throw new ArgumentNullException(nameof(action));

            foreach (var obj in source)
            {
                action(obj);
            }
        }

        /// <summary>
        /// 列挙子の各要素に対して、指定アクション（カウント付き）を実行します。
        /// </summary>
        /// <typeparam name="TSource">列挙される要素の型。</typeparam>
        /// <param name="source">列挙子。</param>
        /// <param name="action">実行するアクション（カウント付き）。</param>
        public static void ForEach<TSource>(this IEnumerable<TSource> source, Action<TSource, int> action)
        {
            if (source == null) throw new ArgumentNullException(nameof(source));
            if (action == null) throw new ArgumentNullException(nameof(action));

            var counter = 0;
            foreach (var obj in source)
            {
                action(obj, counter);
                counter++;
            }
        }
    }
}
