﻿using System;
using System.Collections.ObjectModel;

namespace SdkEnvironmentCheckerLibrary
{
    public class NotNullList<T> : Collection<T> where T : class
    {
        protected override void InsertItem(int index, T item)
        {
            if (item == null) throw new ArgumentNullException(nameof(item));
            base.InsertItem(index, item);
        }

        protected override void SetItem(int index, T item)
        {
            if (item == null) throw new ArgumentNullException(nameof(item));
            base.SetItem(index, item);
        }
    }
}
