﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using YamlDotNet.Serialization;
using YamlDotNet.Serialization.NamingConventions;

namespace QCIT_Maker
{
    internal class SyncListView
    {
        internal class DemoApplication
        {
            [YamlAlias("ApplicationID")]
            public string Id { get; set; }
        }

        internal class AssetData
        {
            [YamlAlias("ApplicationID")]
            public string Id { get; set; }
            [YamlAlias("Index")]
            public string Index { get; set; }
        }

        internal class SyncListData
        {
            [YamlAlias("DemoApplication")]
            public List<DemoApplication> DemoList { get; set; }
            [YamlAlias("AssetData")]
            public List<AssetData> AssetList { get; set; }

            public SyncListData()
            {
                DemoList = new List<DemoApplication>();
                AssetList = new List<AssetData>();
            }
        }

        public SyncListData SyncList { get; set; }
        public bool IsDeserialized { get; set; }

        public SyncListView()
        {
            IsDeserialized = false;
        }

        public void Deserialize(string inSyncListFilePath)
        {
            using (var inputStream = new StreamReader(inSyncListFilePath, Encoding.UTF8))
            {
                var deserializer = new Deserializer(namingConvention: new CamelCaseNamingConvention());
                this.SyncList = deserializer.Deserialize<SyncListData>(inputStream);
            }

            IsDeserialized = true;
            //this.PrintListData();
        }

        public bool IsMatchContent(ContentMetaInfoParam inInfo)
        {
            // 含まれるべき体験版アプリに関連するコンテンツかどうかの確認
            foreach (var app in SyncList.DemoList)
            {
                if (app.Id.ToLower() == inInfo.ApplicationId.ToLower())
                {
                    return true;
                }
            }

            if (inInfo.Type == CommonParams.TypeAddOnContent)
            {
                // 実質的に Quest メニューの Aoc として含まれるかどうかの確認
                foreach (var asData in SyncList.AssetList)
                {
                    if (asData.Id.ToLower() == inInfo.ApplicationId.ToLower() &&
                        asData.Index == inInfo.Index)
                    {
                        return true;
                    }
                }
            }
            else
            {
                // AddOnContent 以外のタイプは Quest メニューのアプリ ID が含まれていれば OK とする
                if (CommonParams.QuestMenuProgramId == inInfo.ApplicationId.ToLower())
                {
                    return true;
                }
            }

            // 上記の条件のいずれにも引っかからないコンテンツは NG とする
            return false;
        }

        // デバック用のログ出力
        private void PrintListData()
        {
            Console.WriteLine("- DemoApplication");
            foreach (var da in SyncList.DemoList)
            {
                Console.WriteLine("    ApplicationID : {0}", da.Id);
            }

            Console.WriteLine("- AssetData");
            foreach (var ad in SyncList.AssetList)
            {
                Console.WriteLine("    ApplicationID : {0}", ad.Id);
                Console.WriteLine("    Index : {0}", ad.Index);
            }
        }
    }
}
