﻿using System;
using System.IO;
using System.Xml;
using System.Xml.Schema;
using CommandUtility;

namespace ReplacePreinstallAppWriter
{
    public class Application
    {
        public string TitleId;
        public int RomInstalled;

    }

    public class PreinstallInfo
    {
        public enum ApplicationSpec
        {
            Normal = 0,
            PreInstalled = 1,
            DigitalBundled = 2
        }

        [System.Xml.Serialization.XmlIgnore]
        public ApplicationSpec InstallApplicationSpec;

        [System.Xml.Serialization.XmlElement("InstallApplicationSpec", Order = 1)]
        public int InstallApplicationSpecInt
        {
            get { return (int)InstallApplicationSpec; }
            set { InstallApplicationSpec = (ApplicationSpec)value; }
        }

        [System.Xml.Serialization.XmlElement("Application", Order = 2)]
        public Application[] Applications;

        public static void GetTypeAndTitleId(out string outType, out string outTitleId, string nspuPath, DirectoryInfo workingDirectory)
        {
            var extractWorkDir = Directory.CreateDirectory(Path.Combine(workingDirectory.FullName, Path.GetRandomFileName()));

            SdkTool.Execute("AuthoringTool.exe",
                "extractnsp",
                nspuPath,
                "-o", extractWorkDir.FullName
            );

            var files = Directory.EnumerateFiles(extractWorkDir.FullName);
            foreach(var i in files)
            {
                if (System.Text.RegularExpressions.Regex.IsMatch(i, @".*\.cnmt\.xml$"))
                {
                    var doc = new System.Xml.XmlDocument();
                    doc.Load(i);
                    var type = doc.SelectSingleNode(@"/ContentMeta/Type");
                    var id = doc.SelectSingleNode(@"/ContentMeta/Id");
                    outType = type.InnerText;
                    outTitleId = id.InnerText;
                    return;
                }
            }

            throw new System.Exception("Cannot find TitleId of " + nspuPath);
        }

        public static void OutputXml(string outputPath, string[] nspuPath, string version, DirectoryInfo workingDirectory)
        {
            var spec = new PreinstallInfo();
            spec.InstallApplicationSpec = ApplicationSpec.PreInstalled;
            spec.Applications = new Application[nspuPath.Length];
            for(int i = 0; i < nspuPath.Length; i++)
            {
                string type;
                string titleId;
                GetTypeAndTitleId(out type, out titleId, nspuPath[i], workingDirectory);
                if(type == "Patch")
                {
                    continue;
                }
                spec.Applications[i] = new Application
                {
                    TitleId = titleId,
                    RomInstalled = 1 // true
                };
            }

            var serializer =  new System.Xml.Serialization.XmlSerializer(typeof(PreinstallInfo));
            using (var sw = new StreamWriter(outputPath, false, new System.Text.UTF8Encoding(false)))
            {
                serializer.Serialize(sw, spec);
            }
        }

        public static void Validate(string xmlPath, string schemaPath)
        {
            var schemaSet = new XmlSchemaSet();
            schemaSet.Add("", schemaPath);

            var settings = new XmlReaderSettings();
            settings.ValidationType = ValidationType.Schema;
            settings.Schemas = schemaSet;

            XmlReader reader = XmlReader.Create(xmlPath, settings);

            while (reader.Read());
        }
    }
}
