﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using YamlDotNet.Serialization;

namespace ReplacePreinstallAppWriter
{
    public class Converter
    {
        public List<string> Application { get; set; }
        public string Version { get; set; }

        public void Validate()
        {
            if (Application == null)
            {
                throw new Exception("Application attribute is null");
            }

            foreach (var i in Application)
            {
                if (!File.Exists(i))
                {
                    throw new Exception("Application \"" + i + "\" does not exist");
                }
            }

            if (Version == null)
            {
                throw new Exception("Version attribute is null");
            }

            if (!System.Text.RegularExpressions.Regex.IsMatch(Version, "^[A-Z0-9]{2}[0-9]{1}$"))
            {
                throw new Exception("Invalid Version format");
            }
        }
        public Converter Parse(FileInfo rule)
        {
            using (var input = new StreamReader(rule.FullName, Encoding.UTF8))
            {
                var yamlDeserializer = new Deserializer();
                var config = yamlDeserializer.Deserialize<Converter>(input);
                config.Validate();
                return config;
            }
        }
    }

}
