﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    /// <summary>
    /// メッセージ種別です。
    /// </summary>
    internal enum MessageType : byte
    {
        /// <summary>
        /// 無し
        /// </summary>
        None,

        /// <summary>
        /// Ping メッセージ
        /// </summary>
        Ping,

        /// <summary>
        /// Pong メッセージ
        /// </summary>
        Pong,

        /// <summary>
        /// Capture サービス開始メッセージ
        /// </summary>
        CaptureStart,

        /// <summary>
        /// Capture サービス停止メッセージ
        /// </summary>
        CaptureStop,

        /// <summary>
        /// キー押下メッセージ
        /// </summary>
        KeyDown,

        /// <summary>
        /// キー解放メッセージ
        /// </summary>
        KeyUp,

        /// <summary>
        /// マウス移動メッセージ
        /// </summary>
        MouseMove,

        /// <summary>
        /// マウスボタンメッセージ
        /// </summary>
        MouseButton,

        /// <summary>
        /// マウスホイールメッセージ
        /// </summary>
        MouseWheel,

        /// <summary>
        /// ゲームパッドボタンメッセージ
        /// </summary>
        GamePadButton,

        /// <summary>
        /// ゲームパッドスティックメッセージ
        /// </summary>
        GamePadStick,

        /// <summary>
        /// ゲームパッド電力メッセージ
        /// </summary>
        GamePadPower,

        /// <summary>
        /// タッチ開始メッセージ
        /// </summary>
        TouchBegan,

        /// <summary>
        /// タッチ移動メッセージ
        /// </summary>
        TouchMoved,

        /// <summary>
        /// タッチ解放メッセージ
        /// </summary>
        TouchEnded,

        /// <summary>
        /// ホームボタンメッセージ
        /// </summary>
        HomeButton,

        /// <summary>
        /// 撮影ボタンメッセージ
        /// </summary>
        CaptureButton,

        /// <summary>
        /// デバッグパッドボタンメッセージ
        /// </summary>
        DebugPadButton,

        /// <summary>
        /// デバッグパッドスティックメッセージ
        /// </summary>
        DebugPadStick,

        /// <summary>
        /// デバッグパッド電力メッセージ
        /// </summary>
        DebugPadPower,

        /// <summary>
        /// Abstracted デバイスデータメッセージ
        /// </summary>
        AbstractedPadDeviceData,

        /// <summary>
        /// Abstracted デバイスカラーメッセージ
        /// </summary>
        AbstractedPadColor,

        /// <summary>
        /// Abstracted 電源情報メッセージ
        /// </summary>
        AbstractedPadPowerState,

        /// <summary>
        /// Abstracted ボタンメッセージ
        /// </summary>
        AbstractedPadButton,

        /// <summary>
        /// Abstracted スティックメッセージ
        /// </summary>
        AbstractedPadStick,
    }
}
