﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System.Runtime.Serialization;
    using System.Windows.Forms;

    /// <summary>
    /// ホットキー設定です。
    /// </summary>
    [DataContract]
    internal sealed class HotKeyConfig
    {
        /// <summary>
        /// HotKeyConfig クラスの新しいインスタンスを初期化します。
        /// </summary>
        internal HotKeyConfig()
        {
        }

        /// <summary>
        /// HotKeyConfig クラスの新しいインスタンスを指定されたホットキー設定に基づいて初期化します。
        /// </summary>
        /// <param name="config">ホットキー設定です。</param>
        internal HotKeyConfig(HotKeyConfig config)
        {
            this.IsEnabled = config.IsEnabled;

            this.Key = config.Key;

            this.Modifier = config.Modifier;
        }

        /// <summary>
        /// ホットキーを有効化するか否かを表す値を取得または設定します。
        /// </summary>
        [DataMember]
        internal bool IsEnabled { get; set; } = true;

        /// <summary>
        /// ホットキーを取得または設定します。
        /// </summary>
        [DataMember]
        internal Keys Key { get; set; } = Keys.F12;

        /// <summary>
        /// ホットキーの修飾キーを取得または設定します。
        /// </summary>
        [DataMember]
        internal Keys Modifier { get; set; } = Keys.Alt;
    }
}
