﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System;
    using Resources;

    /// <summary>
    /// HidShell のエラーが発生した場合にスローされる例外です。
    /// </summary>
    internal sealed class HidShellException : Exception
    {
        /// <summary>
        /// 指定したエラーメッセージを利用して、HidShellException クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="message">例外の原因を説明するエラーメッセージです。</param>
        internal HidShellException(string message)
            : base(message)
        {
        }

        /// <summary>
        /// 指定した HidShell の結果コードを利用して、HidShellException クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="result">HidShell の結果コードです。</param>
        internal HidShellException(HidShellResult result)
            : base(GetHidShellResultMessage(result))
        {
        }

        private static string GetHidShellResultMessage(HidShellResult result)
        {
            switch (result)
            {
                case HidShellResult.Success:
                    return Strings.HidShellResultSuccess;
                case HidShellResult.NullPortPointer:
                    return Strings.HidShellResultNullPortPointer;
                case HidShellResult.InvalidPort:
                    return Strings.HidShellResultInvalidPort;
                case HidShellResult.PortNotFound:
                    return Strings.HidShellResultPortNotFound;
                case HidShellResult.NoAvailablePort:
                    return Strings.HidShellResultNoAvailablePort;
                case HidShellResult.NullPortListPointer:
                    return Strings.HidShellResultNullPortListPointer;
                case HidShellResult.InvalidPortDirection:
                    return Strings.HidShellResultInvalidPortDirection;
                case HidShellResult.NullHandlePointer:
                    return Strings.HidShellResultNullHandlePointer;
                case HidShellResult.InvalidHandle:
                    return Strings.HidShellResultInvalidHandle;
                case HidShellResult.InvalidPortName:
                    return Strings.HidShellResultInvalidPortName;
                case HidShellResult.NullStatePointer:
                    return Strings.HidShellResultNullStatePointer;
                case HidShellResult.StateNotSet:
                    return Strings.HidShellResultStateNotSet;
                case HidShellResult.FailedToCreateMutex:
                    return Strings.HidShellResultFailedToCreateMutex;
                case HidShellResult.FailedToCreateSharedMemory:
                    return Strings.HidShellResultFailedToCreateSharedMemory;
                case HidShellResult.NullAddressPointer:
                    return Strings.HidShellResultNullAddressPointer;
                case HidShellResult.NullExistenceFlagPointer:
                    return Strings.HidShellResultNullExistenceFlagPointer;
                case HidShellResult.InvalidCaptureButtonState:
                    return Strings.HidShellResultInvalidCaptureButtonState;
                case HidShellResult.InvalidDebugPadState:
                    return Strings.HidShellResultInvalidDebugPadState;
                case HidShellResult.InvalidHomeButtonState:
                    return Strings.HidShellResultInvalidHomeButtonState;
                case HidShellResult.InvalidTouchScreenState:
                    return Strings.HidShellResultInvalidTouchScreenState;
                case HidShellResult.InvalidBasicXpadState:
                    return Strings.HidShellResultInvalidBasicXpadState;
                case HidShellResult.InvalidBasicXpadId:
                    return Strings.HidShellResultInvalidBasicXpadId;
                default:
                    return Strings.HidShellResultUnexpectedError;
            }
        }
    }
}
