﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace HidShell
{
    using System.ComponentModel.Composition;

    /// <summary>
    /// デバイスのインターフェイスです。
    /// </summary>
    [InheritedExport]
    internal interface IDevice
    {
        /// <summary>
        /// ポートを設定します。
        /// </summary>
        /// <param name="port">ポートです。</param>
        void SetPort(uint port);

        /// <summary>
        /// ロガーを設定します。
        /// </summary>
        /// <param name="logger">ロガーです。</param>
        void SetLogger(Logger logger);

        /// <summary>
        /// 指定されたデバイス種別をサポートするか否かを表す値を返します。
        /// </summary>
        /// <param name="deviceType">デバイス種別を表す文字列です。</param>
        /// <returns>指定されたデバイス種別をサポートするか否かを表す値です。</returns>
        bool Supports(string deviceType);

        /// <summary>
        /// デバイス識別子で指定されたデバイスについてイベントをダンプします。
        /// </summary>
        /// <param name="deviceId">デバイス識別子です。</param>
        void DumpEvent(string deviceId);

        /// <summary>
        /// デバイス識別子で指定されたデバイスに対してイベントを発行します。
        /// </summary>
        /// <param name="deviceId">デバイス識別子です。</param>
        /// <param name="eventType">イベント種別です。</param>
        /// <param name="eventArgs">イベント引数です。</param>
        void SendEvent(string deviceId, string eventType, string[] eventArgs);
    }
}
