﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//=============================================================================
// include
//=============================================================================
#include "WicUtility.h"

using namespace std;

//=============================================================================
// texcvtr ネームスペースを開始します。
//=============================================================================
namespace nn {
namespace gfx {
namespace tool {
namespace texcvtr {

//-----------------------------------------------------------------------------
//! @brief 必要なら COM を初期化します。
//-----------------------------------------------------------------------------
RStatus WicUtility::InitializeCom()
{
    if (m_InitializesCom)
    {
        if (!m_IsComInitialized)
        {
            HRESULT hr = CoInitializeEx(nullptr, m_CoInit);
                // 同じスレッドモードで既に初期化されている場合は S_FALSE (1) を返します。
                // 異なるスレッドモードで既に初期化されている場合は RPC_E_CHANGED_MODE を返します。
            //cerr << "Initialize COM: " << m_CoInit << ": " << hr << endl;
            if (hr != S_OK && hr != S_FALSE)
            {
                return RStatus(RStatus::FAILURE, "Cannot initialize COM: " + GetWindowsSystemMessage(hr)); // RShowError
            }
            m_IsComInitialized = true;
        }
    }
    return RStatus::SUCCESS;
}

//-----------------------------------------------------------------------------
//! @brief 終了します。
//-----------------------------------------------------------------------------
void WicUtility::Finalize()
{
    if (m_pFactory != nullptr)
    {
        m_pFactory->Release();
        m_pFactory = nullptr;
    }

    if (m_InitializesCom)
    {
        if (m_IsComInitialized)
        {
            //cerr << "Uninitialize COM: " << m_CoInit << endl;
            CoUninitialize();
            m_IsComInitialized = false;
        }
    }
}

//-----------------------------------------------------------------------------
//! @brief ファクトリを取得します。
//-----------------------------------------------------------------------------
IWICImagingFactory* WicUtility::GetFactory(RStatus* pStatus)
{
    RStatus status;

    if (m_pFactory == nullptr)
    {
        status = InitializeCom();
        if (status)
        {
            m_FactoryVersion = 2;
            HRESULT hr = CoCreateInstance(CLSID_WICImagingFactory2, nullptr,
                CLSCTX_INPROC_SERVER, __uuidof(IWICImagingFactory2),
                reinterpret_cast<LPVOID*>(&m_pFactory));
            if (FAILED(hr))
            {
                m_FactoryVersion = 1;
                hr = CoCreateInstance(CLSID_WICImagingFactory1, nullptr,
                    CLSCTX_INPROC_SERVER, __uuidof(IWICImagingFactory),
                    reinterpret_cast<LPVOID*>(&m_pFactory));
            }
            if (FAILED(hr))
            {
                m_pFactory = nullptr;
                status = RStatus(RStatus::FAILURE, "Cannot create imaging factory: " + GetWindowsSystemMessage(hr)); // RShowError
            }
        }
    }

    if (pStatus != nullptr)
    {
        *pStatus = status;
    }
    return m_pFactory;
}

//=============================================================================
// texcvtr ネームスペースを終了します。
//=============================================================================
} // texcvtr
} // tool
} // gfx
} // nn

