﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <gfxTool_ReadFileCallback.h>
#include <gfxTool_CommandLineArg.h>

namespace nn {
namespace gfxTool {

void ReadFileCallback::AddDirectory( const char* directory )
{
    // TODO パス変換
    m_Directories.push_back( directory );
    std::replace( m_Directories.back().begin(), m_Directories.back().end(), '/', '\\' );
    if( m_Directories.back().length() > 0 && m_Directories.back().back() != '\\' )
    {
        m_Directories.back().push_back( '\\' );
    }
}

bool ReadFileCallback::Callback( void** ppOutFileData, size_t* pOutFileDataSize,
    const char* pFileName, void* pParam )
{
    auto pThis = static_cast< ReadFileCallback* >( pParam );
    if (pThis->m_pCallback)
    {
        if (pThis->m_Directories.size() < 1)
        {
            return pThis->m_pCallback(ppOutFileData, pOutFileDataSize, pFileName, pThis->m_pCallbackParam);
        }

        for (auto& directory : pThis->m_Directories)
        {
            auto path = directory + pFileName;
            if (pThis->m_pCallback(ppOutFileData, pOutFileDataSize, path.data(), pThis->m_pCallbackParam))
            {
                return true;
            }
        }
    }
    return false;
}

}
}
