﻿/*--------------------------------------------------------------------------------*
Copyright (C)Nintendo All rights reserved.

These coded instructions, statements, and computer programs contain proprietary
information of Nintendo and/or its licensed developers and are protected by
national and international copyright laws. They may not be disclosed to third
parties or copied or duplicated in any form, in whole or in part, without the
prior written consent of Nintendo.

The content herein is highly confidential and should be handled accordingly.
*--------------------------------------------------------------------------------*/
#include <gfxTool_FullReflectionBinarizer.h>
#include <gfxTool_ShaderBinarizerContext.h>

namespace nn {
namespace gfxTool {

template< typename Func >
void FullReflectionBinarizer::ForEachReflections( Func func )
{
    func( m_ReflectionBlocks + static_cast<int>( ReflectionType::ConstantBuffer ),
        &nngfxToolShaderCompilerShaderReflection::constantBufferCount,
        &nngfxToolShaderCompilerShaderReflection::pConstantBufferArray );
    func( m_ReflectionBlocks + static_cast<int>( ReflectionType::UnorderedAccessBuffer ),
        &nngfxToolShaderCompilerShaderReflection::unorderedAccessBufferCount,
        &nngfxToolShaderCompilerShaderReflection::pUnorderedAccessBufferArray );
    func( m_ReflectionBlocks + static_cast<int>( ReflectionType::Input ),
        &nngfxToolShaderCompilerShaderReflection::shaderInputCount,
        &nngfxToolShaderCompilerShaderReflection::pShaderInputArray );
    func( m_ReflectionBlocks + static_cast<int>( ReflectionType::Output ),
        &nngfxToolShaderCompilerShaderReflection::shaderOutputCount,
        &nngfxToolShaderCompilerShaderReflection::pShaderOutputArray );
    func( m_ReflectionBlocks + static_cast<int>( ReflectionType::Sampler ),
        &nngfxToolShaderCompilerShaderReflection::samplerCount,
        &nngfxToolShaderCompilerShaderReflection::pSamplerArray );
    func( m_ReflectionBlocks + static_cast<int>( ReflectionType::ConstantBufferVariable ),
        &nngfxToolShaderCompilerShaderReflection::constantBufferVariableCount,
        &nngfxToolShaderCompilerShaderReflection::pConstantBufferVariableArray );
    func( m_ReflectionBlocks + static_cast<int>( ReflectionType::UnorderedAccessBufferVariable ),
        &nngfxToolShaderCompilerShaderReflection::unorderedAccessBufferVariableCount,
        &nngfxToolShaderCompilerShaderReflection::pUnorderedAccessBufferVariableArray );
    func( m_ReflectionBlocks + static_cast<int>( ReflectionType::Image ),
        &nngfxToolShaderCompilerShaderReflection::imageCount,
        &nngfxToolShaderCompilerShaderReflection::pImageArray );
    func( m_ReflectionBlocks + static_cast<int>( ReflectionType::SeparateTexture ),
        &nngfxToolShaderCompilerShaderReflection::separateTextureCount,
        &nngfxToolShaderCompilerShaderReflection::pSeparateTextureArray );
    func( m_ReflectionBlocks + static_cast<int>( ReflectionType::SeparateSampler ),
        &nngfxToolShaderCompilerShaderReflection::separateSamplerCount,
        &nngfxToolShaderCompilerShaderReflection::pSeparateSamplerArray );
}

void FullReflectionBinarizer::Initialize( const BinarizationTarget* pTarget )
{
    m_pTarget = pTarget;
}

void FullReflectionBinarizer::RegisterChild( ShaderBinarizerContext* pContext )
{
    ForEachReflections( [ & ]( Custom< std::vector< nn::util::MemorySplitter::MemoryBlock > >::Type* pBlocks,
        uint32_t nngfxToolShaderCompilerShaderReflection::*pCount, auto )
    {
        pBlocks->resize( m_pTarget->*pCount );
        for( auto&& block : *pBlocks )
        {
            pContext->AddMemoryBlock( static_cast<int>( Section::Common ), &block );
        }
    } );
}

void FullReflectionBinarizer::CalculateSize()
{
    SetSizeBy< ResTarget >();

    ForEachReflections( [ & ]( Custom< std::vector< nn::util::MemorySplitter::MemoryBlock > >::Type* pBlocks,
        uint32_t nngfxToolShaderCompilerShaderReflection::*, auto pReflections )
    {
        for( auto&& block : *pBlocks )
        {
            block.SetSizeBy< decltype( *( static_cast< ResTarget* >( nullptr )->*pReflections ) ) >();
            NN_UNUSED( pReflections );
        }
    } );
}

void FullReflectionBinarizer::Link( ShaderBinarizerContext* pContext )
{
    const ResTarget* pResTarget = nullptr;

    ForEachReflections( [ & ]( Custom< std::vector< nn::util::MemorySplitter::MemoryBlock > >::Type* pBlocks,
        uint32_t nngfxToolShaderCompilerShaderReflection::*, auto pReflections )
    {
        if( pBlocks->size() > 0 )
        {
            pContext->LinkPtr( this, reinterpret_cast<const nn::util::BinTPtr< void >*>(
                &( pResTarget->*pReflections ) ), &pBlocks->at( 0 ) );
            auto pSrcReflections = m_pTarget->*pReflections;
            for( auto&& block : *pBlocks )
            {
                decltype( pResTarget->*pReflections ) pDstReflections = nullptr;
                pContext->LinkNativeString( &block, reinterpret_cast<
                    nn::util::BinPtrToString* >( &pDstReflections->name.pValue ),
                    nn::util::string_view( pSrcReflections->name.pValue, pSrcReflections->name.length ) );
                ++pSrcReflections;
            }
        }
    } );
}

void FullReflectionBinarizer::Convert( ShaderBinarizerContext* pContext )
{
    auto pResTarget = Get< ResTarget >( pContext->GetPtr() );

    *pResTarget = *m_pTarget;

    ForEachReflections( [ & ]( Custom< std::vector< nn::util::MemorySplitter::MemoryBlock > >::Type* pBlocks,
        uint32_t nngfxToolShaderCompilerShaderReflection::*, auto pReflections )
    {
        auto pSrcReflections = m_pTarget->*pReflections;
        for( auto&& block : *pBlocks )
        {
            *block.Get< std::remove_pointer< decltype(
                pSrcReflections ) >::type >( pContext->GetPtr() ) = *pSrcReflections++;
        }
    } );
}

}
}
