﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <gfxTool_CommandLineArg.h>

namespace nn {
namespace gfxTool {

void InitializeOptions( CommandLineArg* pInput, CommandLineParser* pParser )
{
    pParser->SetOption( pInput->help.Define(
        false, 'h', "help", "Displays Help." ) );
    pParser->SetOption( pInput->version.Define(
        false, 'v', "version", "Displays version information." ) );

    pParser->SetOption( pInput->outputPath.Define(
        true, 'o', "output-path", "Specifies the output path." ) );
    pParser->SetOption( pInput->sourceFormat.Define(
        false, 's', "source-format", "Specifies the shader source format." ) );
    pParser->SetOption( pInput->codeType.Define(
        false, 'c', "code-type", "Specifies the shader output code type." ) );
    pParser->SetOption( pInput->apiType.Define(
        false, 'a', "api-type", "Specifies the low-level graphics API type." ) );

    pParser->SetOption( pInput->shaderFile[ static_cast< int >( ShaderStage::Vertex ) ].Define(
        false, "vertex-shader", "Specifies the vertex shader source code." ) );
    pParser->SetOption( pInput->shaderFile[ static_cast< int >( ShaderStage::Hull ) ].Define(
        false, "hull-shader", "Specifies the hull shader source code." ) );
    pParser->SetOption( pInput->shaderFile[ static_cast< int >( ShaderStage::Domain ) ].Define(
        false, "domain-shader", "Specifies the domain shader source code." ) );
    pParser->SetOption( pInput->shaderFile[ static_cast< int >( ShaderStage::Geometry ) ].Define(
        false, "geometry-shader", "Specifies the geometry shader source code." ) );
    pParser->SetOption( pInput->shaderFile[ static_cast< int >( ShaderStage::Pixel ) ].Define(
        false, "pixel-shader", "Specifies the pixel shader source code." ) );
    pParser->SetOption( pInput->shaderFile[ static_cast< int >( ShaderStage::Compute ) ].Define(
        false, "compute-shader", "Specifies the compute shader source code." ) );
    pParser->SetOption( pInput->variationFile.Define(
        false, "variation", "Specifies the variation file." ) );
    pParser->SetOption( pInput->dumpDirectory.Define(
        false, "dump-directory", "Dumps the source code before compiling to the specified directory." ) );
    pParser->SetOption( pInput->printProgress.Define(
        false, "print-progress", "Displays the progress during compilation." ) );
    pParser->SetOption( pInput->silent.Define(
        false, "silent", "Don't display progress infomation." ) );
    pParser->SetOption( pInput->includeDirectory.Define(
        false, "include-directory", "Adds an include directory." ) );

    pParser->SetOption( pInput->preprocessorDefinitions.Define(
        false, "preprocessor-definition", "Adds a preprocessor definition." ) );
    pParser->SetOption( pInput->outputName.Define(
        false, "output-name", "Specifies the name of the output binary." ) );
    pParser->SetOption( pInput->maxThread.Define(
        false, "max-thread", "Specifies the maximum thread count." ) );
    pParser->SetOption( pInput->jobs.Define(
        false, 'j', "jobs", "Specifies the maximum thread count." ) );
    pParser->SetOption( pInput->codePage.Define(
        false, "code-page", "Specifies the code page of the source code file." ) );

    pParser->SetOption( pInput->separable.Define(
        false, "separable", "Compiles as a separate shader for each stage." ) );

    pParser->SetOption( pInput->reflection.Define(
        false, "reflection", "Adds reflection information" ) );
    pParser->SetOption( pInput->reflectionFull.Define(
        false, "reflection-full", "Adds full reflection information." ) );

    pParser->SetOption( pInput->glslVersion.Define(
        false, "glsl-version", "Specifies the GLSL version to include at the start of the source code." ) );
    pParser->SetOption( pInput->glslExtensions.Define(
        false, "glsl-extension", "Specifies the GLSL extension to include at the start of the source code." ) );

    pParser->SetOption( pInput->disableMemoryPool.Define(
        false, "disable-memory-pool", "Tries not to include memory pool in resources." ) );

    pParser->SetOption( pInput->preprocess.Define(
        false, "preprocess", "The shader resource is preprocessed before passing to the low-level compiler." ) );

    pParser->SetOption( pInput->debugInfoLevel.Define(
        false, "debug-info-level", "Specify the debug information level to attach to the binary." ) );
    pParser->SetOption( pInput->debugInfoDirectory.Define(
        false, "debug-info-directory", "Save the debug info data to the specified directory." ) );
    pParser->SetOption( pInput->shaderCacheDirectory.Define(
        false, "shader-cache-directory", "Save/Load the compiled result to/from the specified directory." ) );

    pParser->SetOption( pInput->uniformRegisterBlockName.Define(
        false, "uniform-register-block-name", "Specifies the block name for uniform registers." ) );

    pParser->SetOption( pInput->invertGlPositionY.Define(
        false, "invert-y", "Inverts gl_Position.y. This implicitly enables --preprocess." ) );
    pParser->SetOption( pInput->remapGlPositionZ.Define(
        false, "remap-z", "Remaps Z from [-1, 1] to [0, 1]. This implicitly enables --preprocess." ) );

    pParser->SetOption( pInput->disableMergeProgram.Define(
        false, "disable-merge-program", "Disables merging the compiled result which is equal functionally." ) );

    /*pParser->SetOption( pInput->gx2SparkDir.Define(
        false, "gx2-spark-dir", "Specify the output directory for Spark symbol information." ) );
    pParser->SetOption( pInput->gx2OptimizeFlags.Define(
        false, "gx2-optimize-flags", "Specifies the optimization flags." ) );*/

    pParser->SetOption( pInput->decomposeBinary.Define(
        false, "decompose-binary", "Decompose shader binary to reduce the resource size." ) );
    pParser->SetOption( pInput->glslcOptionFlags.Define(
        false, "glslc-option-flags", "Specifies GLSLCoptionFlags." ) );

    pParser->SetOption( pInput->mergeShaderFile.Define(
        false, "merge-shader-file", "Specifies shader file name which the result merged shader file contains." ) );

    // Vulkan-specific options
    pParser->SetOption( pInput->autoMapUniformBinding.Define(
        false, "auto-map-binding", "Automatically sets uniform layout binding information." ) );
    pParser->SetOption( pInput->autoMapInOutLocation.Define(
        false, "auto-map-location", "Automatically sets in/out layout location information." ) );
}

}
}
