﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/utilTool/utilTool_XmlParser.h>

#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

template< typename TChildNode >
class ArrayNode
    : public nn::utilTool::XmlNode
{
    NN_DISALLOW_COPY( ArrayNode );

public:
    typedef TChildNode ChildType;

    nn::util::string_view GetLengthAttribute() const
    {
        return FindAttribute( "length" );
    }

    const ChildType* GetNextChild( const ChildType* pChildNode ) const
    {
        return StaticCastAuto( pChildNode ?
            pChildNode->GetNext() : FindChild( ChildType::GetId() ) );
    }
};

template< typename TNode >
class IndexAttribute
{
public:
    nn::util::string_view GetIndexAttribute() const
    {
        return static_cast< const TNode* >( this )->FindAttribute( "index" );
    }
};

template< typename TNode >
class NameAttribute
{
public:
    nn::util::string_view GetNameAttribute() const
    {
        return static_cast< const TNode* >( this )->FindAttribute( "name" );
    }
};

class VariationConstantBufferNode
    : public nn::utilTool::XmlNode
    , public NameAttribute< VariationConstantBufferNode >
{
    NN_DISALLOW_COPY( VariationConstantBufferNode );

public:
    static const char* GetId()
    {
        return "VariationConstantBuffer";
    }
};

class VariationConstantDefinitionNode
    : public nn::utilTool::XmlNode
    , public IndexAttribute< VariationConstantDefinitionNode >
    , public NameAttribute< VariationConstantDefinitionNode >
{
    NN_DISALLOW_COPY( VariationConstantDefinitionNode );

public:
    static const char* GetId()
    {
        return "VariationConstantDefinition";
    }

    nn::util::string_view GetTypeAttribute() const
    {
        return FindAttribute( "type" );
    }
};

class VariationConstantDefinitionArrayNode
    : public ArrayNode< VariationConstantDefinitionNode >
{
    NN_DISALLOW_COPY( VariationConstantDefinitionArrayNode );

public:
    static const char* GetId()
    {
        return "VariationConstantDefinitionArray";
    }
};

class PreprocessorDefinitionDefinitionNode
    : public nn::utilTool::XmlNode
    , public IndexAttribute< PreprocessorDefinitionDefinitionNode >
    , public NameAttribute< PreprocessorDefinitionDefinitionNode >
{
    NN_DISALLOW_COPY( PreprocessorDefinitionDefinitionNode );

public:
    static const char* GetId()
    {
        return "PreprocessorDefinitionDefinition";
    }
};

class PreprocessorDefinitionDefinitionArrayNode
    : public ArrayNode< PreprocessorDefinitionDefinitionNode >
{
    NN_DISALLOW_COPY( PreprocessorDefinitionDefinitionArrayNode );

public:
    static const char* GetId()
    {
        return "PreprocessorDefinitionDefinitionArray";
    }
};

class StageShaderVariationDefinitionNode
    : public nn::utilTool::XmlNode
{
    NN_DISALLOW_COPY( StageShaderVariationDefinitionNode );

public:
    static const char* GetId( ShaderStage stage )
    {
        static const char* stageIds[] =
        {
            "VertexShaderVariationDefinition",
            "HullShaderVariationDefinition",
            "DomainShaderVariationDefinition",
            "GeometryShaderVariationDefinition",
            "PixelShaderVariationDefinition",
            "ComputeShaderVariationDefinition"
        };
        return stageIds[ static_cast< int >( stage ) ];
    }

    const VariationConstantBufferNode* GetVariationConstantBufferNode() const
    {
        return StaticCastAuto( FindChild( VariationConstantBufferNode::GetId() ) );
    }

    const VariationConstantDefinitionArrayNode* GetVariationConstantDefinitionArrayNode() const
    {
        return StaticCastAuto( FindChild( VariationConstantDefinitionArrayNode::GetId() ) );
    }

    const PreprocessorDefinitionDefinitionArrayNode* GetPreprocessorDefinitionDefinitionArrayNode() const
    {
        return StaticCastAuto( FindChild( PreprocessorDefinitionDefinitionArrayNode::GetId() ) );
    }
};

class ShaderVariationDefinitionNode
    : public nn::utilTool::XmlNode
{
    NN_DISALLOW_COPY( ShaderVariationDefinitionNode );

public:
    static const char* GetId()
    {
        return "ShaderVariationDefinition";
    }

    const StageShaderVariationDefinitionNode* GetStageShaderVariationDefinitionNode( ShaderStage stage ) const
    {
        return StaticCastAuto( FindChild( StageShaderVariationDefinitionNode::GetId( stage ) ) );
    }
};

class VariationConstantValueNode
    : public nn::utilTool::XmlNode
    , public IndexAttribute< VariationConstantValueNode >
{
    NN_DISALLOW_COPY( VariationConstantValueNode );

public:
    static const char* GetId()
    {
        return "VariationConstantValue";
    }
};

class VariationConstantValueArrayNode
    : public ArrayNode< VariationConstantValueNode >
{
    NN_DISALLOW_COPY( VariationConstantValueArrayNode );

public:
    static const char* GetId()
    {
        return "VariationConstantValueArray";
    }
};

class PreprocessorDefinitionValueNode
    : public nn::utilTool::XmlNode
    , public IndexAttribute< PreprocessorDefinitionValueNode >
{
    NN_DISALLOW_COPY( PreprocessorDefinitionValueNode );

public:
    static const char* GetId()
    {
        return "PreprocessorDefinitionValue";
    }
};

class PreprocessorDefinitionValueArrayNode
    : public ArrayNode< PreprocessorDefinitionValueNode >
{
    NN_DISALLOW_COPY( PreprocessorDefinitionValueArrayNode );

public:
    static const char* GetId()
    {
        return "PreprocessorDefinitionValueArray";
    }
};

class StageShaderVariationValueNode
    : public nn::utilTool::XmlNode
{
    NN_DISALLOW_COPY( StageShaderVariationValueNode );

public:
    static const char* GetId( ShaderStage stage )
    {
        static const char* stageIds[] =
        {
            "VertexShaderVariationValue",
            "HullShaderVariationValue",
            "DomainShaderVariationValue",
            "GeometryShaderVariationValue",
            "PixelShaderVariationValue",
            "ComputeShaderVariationValue"
        };
        return stageIds[ static_cast< int >( stage ) ];
    }

    const VariationConstantValueArrayNode* GetVariationConstantValueArrayNode() const
    {
        return StaticCastAuto( FindChild( VariationConstantValueArrayNode::GetId() ) );
    }

    const PreprocessorDefinitionValueArrayNode* GetPreprocessorDefinitionValueArrayNode() const
    {
        return StaticCastAuto( FindChild( PreprocessorDefinitionValueArrayNode::GetId() ) );
    }
};

class ShaderVariationValueNode
    : public nn::utilTool::XmlNode
    , IndexAttribute< ShaderVariationValueNode >
{
    NN_DISALLOW_COPY( ShaderVariationValueNode );

public:
    static const char* GetId()
    {
        return "ShaderVariationValue";
    }

    const StageShaderVariationValueNode* GetStageShaderVariationValueNode( ShaderStage stage ) const
    {
        return StaticCastAuto( FindChild( StageShaderVariationValueNode::GetId( stage ) ) );
    }
};

class ShaderVariationValueArrayNode
    : public ArrayNode< ShaderVariationValueNode >
{
    NN_DISALLOW_COPY( ShaderVariationValueArrayNode );

public:
    static const char* GetId()
    {
        return "ShaderVariationValueArray";
    }
};

class GfxShaderVariationNode
    : public nn::utilTool::XmlNode
{
    NN_DISALLOW_COPY( GfxShaderVariationNode );

public:
    static const char* GetId()
    {
        return "GfxShaderVariation";
    }

    nn::util::string_view GetVersion() const
    {
        return FindAttribute( "version" );
    }

    const ShaderVariationDefinitionNode* GetShaderVariationDefinition() const
    {
        return StaticCastAuto( FindChild( ShaderVariationDefinitionNode::GetId() ) );
    }

    const ShaderVariationValueArrayNode* GetShaderVariationValueArrayNode() const
    {
        return StaticCastAuto( FindChild( ShaderVariationValueArrayNode::GetId() ) );
    }
};

class VariationXml
    : public nn::utilTool::XmlParser
{
public:
    const GfxShaderVariationNode* GetGfxShaderVariation() const
    {
        return StaticCastAuto( GetRoot() );
    }
};

}
}
