﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <gfxTool_Common.h>
#include <gfxTool_ReadFileCallback.h>
#include <gfxTool_WriteFileCallback.h>

namespace nn {
namespace gfxTool {

class VariationDefinitionArg;
class VariationValueArg;
class CompileOption;

struct CommandLineArg;

class CompileArg
    : public nngfxToolShaderCompilerCompileArg
{
public:
    CompileArg();

    ~CompileArg();

    void Initialize( const nngfxToolShaderConverterCreateConvertArgArg* pArg,
        const CommandLineArg* pInput );

private:
    void InitializeVariation( const nngfxToolShaderConverterCreateConvertArgArg* pArg,
        const CommandLineArg* pInput );

    Custom< std::unique_ptr< VariationDefinitionArg > >::Type m_pVariationDefinitionArg;

    Custom< std::vector< nngfxToolShaderCompilerVariationValueArg > >::Type m_VariationValueArrayRaw;
    Custom< std::vector< VariationValueArg > >::Type m_VariationValueArray;

    Custom< std::unique_ptr< CompileOption > >::Type m_pCompileOption;

    ReadFileCallback m_ReadIncludeFile;
    WriteFileCallback m_WriteDebugInfoFile;
    ReadFileCallback m_ReadShaderCache;
    WriteFileCallback m_WriteShaderCache;
};

}
}
