﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/util/util_BinTypes.h>

#include "..\..\ShaderCompiler\Include\gfxTool_Common.h"

#include <nn/gfx/gfx_ShaderInfoData.h>

#include <nn/gfxTool/gfxTool_Custom.h>
#include <nn/gfxTool/gfxTool_Error.h>
#include <nn/gfxTool/gfxTool_ResultCode.h>

#include <nn/gfxTool/gfxTool_ShaderConverterApi.h>
#include <nn/gfxTool/gfxTool_ShaderCompilerApi.h>
#include <nn/gfxTool/gfxTool_ShaderCompilerApi-gx.h>
#include <nn/gfxTool/gfxTool_ShaderCompilerApi-nvn.h>
#include <nn/gfxTool/gfxTool_ShaderCompilerApi-d3d.h>
#include <nn/gfxTool/gfxTool_ShaderCompilerApi-vk.h>

#include <gfxTool_Enum.h>

namespace nn {
namespace gfx {

struct ResShaderProgramData;
struct ResShaderStageData;
struct ResShaderVariationData;
struct ResShaderContainerData;
struct ResShaderFileData;

}
}

namespace nn {
namespace gfxTool {

inline nn::gfx::detail::Ptr< const void > GetStageCode(
    const nn::gfx::ShaderInfoData* pInfo, ShaderStage stage )
{
    static nn::gfx::detail::Ptr< const void > nn::gfx::ShaderInfoData::* const s_pStageCode[] =
    {
        &nn::gfx::ShaderInfoData::pVertexShaderCode,
        &nn::gfx::ShaderInfoData::pHullShaderCode,
        &nn::gfx::ShaderInfoData::pDomainShaderCode,
        &nn::gfx::ShaderInfoData::pGeometryShaderCode,
        &nn::gfx::ShaderInfoData::pPixelShaderCode,
        &nn::gfx::ShaderInfoData::pComputeShaderCode
    };
    return pInfo->*s_pStageCode[ static_cast< int >( stage ) ];
}

void* GetShaderConverterModuleHandle();

}
}
