﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfxTool/gfxTool_ShaderCompilerApi.h>
#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_ShaderCompilerContext.h>
#include <gfxTool_CompileOutput.h>

NN_GFXTOOL_SHADERCOMPILER_API nngfxToolResultCode nngfxToolShaderCompilerCreateHandle(
    nngfxToolHandle* pOutHandle, const nngfxToolShaderCompilerCreateHandleArg* pArg )
{
    NN_UNUSED( pArg );
    return ( *pOutHandle = nn::gfxTool::ShaderCompilerContext::Create() ) == 0
        ? nngfxToolResultCode_Failed : nngfxToolResultCode_Succeeded;
}

NN_GFXTOOL_SHADERCOMPILER_API nngfxToolResultCode nngfxToolShaderCompilerResetHandle(
    nngfxToolHandle handle )
{
    auto ptr = nn::gfxTool::ShaderCompilerContext::Get( handle );
    return ptr == nullptr ? nngfxToolResultCode_InvalidHandle : ptr->Reset();
}

NN_GFXTOOL_SHADERCOMPILER_API nngfxToolResultCode nngfxToolShaderCompilerCompile(
    nngfxToolShaderCompilerCompileOutput** ppOutput, nngfxToolHandle handle,
    const nngfxToolShaderCompilerCompileArg* pArg )
{
    auto ptr = nn::gfxTool::ShaderCompilerContext::Get( handle );
    return ptr == nullptr ? nngfxToolResultCode_InvalidHandle : ptr->Compile( ppOutput, pArg );
}

NN_GFXTOOL_SHADERCOMPILER_API nngfxToolResultCode nngfxToolShaderCompilerDeleteHandle(
    nngfxToolHandle handle )
{
    return nn::gfxTool::ShaderCompilerContext::Delete( handle );
}

NN_GFXTOOL_SHADERCOMPILER_API nngfxToolResultCode nngfxToolShaderCompilerDeleteCompileOutput(
    nngfxToolShaderCompilerCompileOutput* pOutput )
{
    return nn::gfxTool::CompileOutput::Delete( nn::gfxTool::CompileOutput::DownCast( pOutput ) );
}

NN_GFXTOOL_SHADERCOMPILER_API nngfxToolResultCode nngfxToolShaderCompilerSetLogStream(
    const nngfxToolSetLogStreamArg* pArg )
{
    nn::gfxTool::Logger::SetStream( nn::gfxTool::StaticCastAuto( pArg->logType ), pArg->hLogStream );
    return nngfxToolResultCode_Succeeded;
}

NN_GFXTOOL_SHADERCOMPILER_API nngfxToolResultCode nngfxToolShaderCompilerGetApiVersion(
    nngfxToolApiVersion* pOutApiVersion )
{
    if( pOutApiVersion == nullptr )
    {
        return nngfxToolResultCode_InvalidArgument;
    }
    pOutApiVersion->major = nngfxToolShaderCompilerVersion_Major;
    pOutApiVersion->minor = nngfxToolShaderCompilerVersion_Minor;
    pOutApiVersion->micro = nngfxToolShaderCompilerVersion_Micro;
    return nngfxToolResultCode_Succeeded;
}

NN_STATIC_ASSERT( sizeof( nngfxToolString ) == 16 );
NN_STATIC_ASSERT( sizeof( nngfxToolSetLogStreamArg ) == 32 );
NN_STATIC_ASSERT( sizeof( nngfxToolApiVersion ) == 16 );

NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerCreateHandleArg ) == 32 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerVariationConstantValue ) == 32 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerVariationValue ) == 56 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerVariationConstantDefinition ) == 64 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerPreprocessorDefinitionDefinition ) == 40 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerVariationDefinition ) == 72 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerCompileOption ) == 32 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerCompileOptionCommon ) == 88 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerCompileOptionGlsl ) == 80 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerVariationDefinitionArg ) == 112 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerVariationValueArg ) == 112 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerCompileArg ) == 232 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerShaderSlot ) == 32 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerConstantBuffer ) == 88 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerUnorderedAccessBuffer ) == 88 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerShaderInput ) == 64 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerShaderOutput ) == 64 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerSampler ) == 88 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerImage ) == 88 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerConstantBufferVariable ) == 64 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerUnorderedAccessBufferVariable ) == 64 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerShaderReflection ) == 152 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerOptionOutput ) == 32 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerOptionOutputStageCommon ) == 72 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerOptionOutputProgramCommon ) == 88 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerShaderProgramOutput ) == 56 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerVariationOutput ) == 56 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderCompilerCompileOutput ) == 88 );

