﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <nn/nn_Windows.h>

#include <gfxTool_GlFunction.h>

namespace {

template< typename TFunc >
TFunc GetRequiredGlFunction( const char* pFunctionName )
{
    auto ret = ::wglGetProcAddress( pFunctionName );
    if( ret == nullptr )
    {
        NN_GFXTOOL_THROW_MSG( nngfxToolResultCode_FailedToGetGlFunction, "Failed to load %s.", pFunctionName );
    }
    return reinterpret_cast< TFunc >( ret );
}

}

namespace nn {
namespace gfxTool {

void GlFunction::Initialize()
{
    CreateShader = GetRequiredGlFunction< decltype( CreateShader ) >( "glCreateShader" );
    DeleteShader = GetRequiredGlFunction< decltype( DeleteShader ) >( "glDeleteShader" );
    CreateProgram = GetRequiredGlFunction< decltype( CreateProgram ) >( "glCreateProgram" );
    DeleteProgram = GetRequiredGlFunction< decltype( DeleteProgram ) >( "glDeleteProgram" );
    ReleaseShaderCompiler = GetRequiredGlFunction< decltype( ReleaseShaderCompiler ) >( "glReleaseShaderCompiler" );

    GetShaderiv = GetRequiredGlFunction< decltype( GetShaderiv ) >( "glGetShaderiv" );
    GetShaderInfoLog = GetRequiredGlFunction< decltype( GetShaderInfoLog ) >( "glGetShaderInfoLog" );
    GetProgramiv = GetRequiredGlFunction< decltype( GetProgramiv ) >( "glGetProgramiv" );
    GetProgramInfoLog = GetRequiredGlFunction< decltype( GetProgramInfoLog ) >( "glGetProgramInfoLog" );

    ShaderSource = GetRequiredGlFunction< decltype( ShaderSource ) >( "glShaderSource" );
    CompileShader = GetRequiredGlFunction< decltype( CompileShader ) >( "glCompileShader" );
    AttachShader = GetRequiredGlFunction< decltype( AttachShader ) >( "glAttachShader" );
    DetachShader = GetRequiredGlFunction< decltype( DetachShader ) >( "glDetachShader" );
    LinkProgram = GetRequiredGlFunction< decltype( LinkProgram ) >( "glLinkProgram" );
    ProgramParameteri = GetRequiredGlFunction< decltype( ProgramParameteri ) >( "glProgramParameteri" );

    GetProgramBinary = GetRequiredGlFunction< decltype( GetProgramBinary ) >( "glGetProgramBinary" );

    GetProgramInterfaceiv = GetRequiredGlFunction< decltype( GetProgramInterfaceiv ) >( "glGetProgramInterfaceiv" );
    GetProgramResourceiv = GetRequiredGlFunction< decltype( GetProgramResourceiv ) >( "glGetProgramResourceiv" );
    GetProgramResourceName = GetRequiredGlFunction< decltype( GetProgramResourceName ) >( "glGetProgramResourceName" );
    GetUniformiv = GetRequiredGlFunction< decltype( GetUniformiv ) >( "glGetUniformiv" );
}

}
}
