﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <gfxTool_CompilerManager.h>
#include <gfxTool_Compiler-gl-source.h>
#include <gfxTool_Compiler-gl-binary.h>
#include <gfxTool_Compiler-gx-binary.h>
#include <gfxTool_Compiler-nvn-binary.h>
#include <gfxTool_Compiler-d3d-source.h>
#include <gfxTool_Compiler-vk-ir.h>

namespace nn {
namespace gfxTool {

CompilerManager::CompilerManager() /* = default; */
{
}

CompilerManager::~CompilerManager() /* = default; */
{
}

template<>
void CompilerManager::CompileImpl< nngfxToolShaderCompilerLowLevelApiType_Gl >( CompileOutput* pOutput,
    const ShaderCompilerContext* pContext, const nngfxToolShaderCompilerCompileArg* pArg )
{
    auto codeType = static_cast< nngfxToolShaderCompilerCodeType >( pArg->targetCodeType );
    if( HasSource( codeType ) )
    {
        m_pSourceCompiler.reset( new Compiler< CompilerVariation<
            nngfxToolShaderCompilerLowLevelApiType_Gl,
            nngfxToolShaderCompilerCodeType_Source > >() );
        m_pSourceCompiler->Compile( pOutput, pContext, pArg );
    }
    if( HasBinary( codeType ) )
    {
        m_pBinaryCompiler.reset( new Compiler< CompilerVariation<
            nngfxToolShaderCompilerLowLevelApiType_Gl,
            nngfxToolShaderCompilerCodeType_Binary > >() );
        m_pBinaryCompiler->Compile( pOutput, pContext, pArg );
    }
}

template<>
void CompilerManager::CompileImpl< static_cast< nngfxToolShaderCompilerLowLevelApiType >(
    nngfxToolShaderCompilerLowLevelApiType_Gx ) >( CompileOutput* pOutput,
    const ShaderCompilerContext* pContext, const nngfxToolShaderCompilerCompileArg* pArg )
{
    if( pArg->targetCodeType == nngfxToolShaderCompilerCodeType_Binary )
    {
        m_pBinaryCompiler.reset( new Compiler< CompilerVariation< static_cast<
            nngfxToolShaderCompilerLowLevelApiType >( nngfxToolShaderCompilerLowLevelApiType_Gx ),
            nngfxToolShaderCompilerCodeType_Binary > >() );
        m_pBinaryCompiler->Compile( pOutput, pContext, pArg );
    }
    else
    {
        NN_GFXTOOL_THROW( nngfxToolResultCode_InvalidCodeType );
    }
}

template<>
void CompilerManager::CompileImpl< static_cast< nngfxToolShaderCompilerLowLevelApiType >(
    nngfxToolShaderCompilerLowLevelApiType_Nvn ) >( CompileOutput* pOutput,
    const ShaderCompilerContext* pContext, const nngfxToolShaderCompilerCompileArg* pArg )
{
    if( pArg->targetCodeType == nngfxToolShaderCompilerCodeType_Binary ||
        pArg->targetCodeType == nngfxToolShaderCompilerCodeType_Binary_Ir )
    {
        m_pBinaryCompiler.reset( new Compiler< CompilerVariation< static_cast<
            nngfxToolShaderCompilerLowLevelApiType >( nngfxToolShaderCompilerLowLevelApiType_Nvn ),
            nngfxToolShaderCompilerCodeType_Binary > >() );
        m_pBinaryCompiler->Compile( pOutput, pContext, pArg );
    }
    else
    {
        NN_GFXTOOL_THROW( nngfxToolResultCode_InvalidCodeType );
    }
}

template<>
void CompilerManager::CompileImpl< static_cast< nngfxToolShaderCompilerLowLevelApiType >(
    nngfxToolShaderCompilerLowLevelApiType_D3d ) >( CompileOutput* pOutput,
    const ShaderCompilerContext* pContext, const nngfxToolShaderCompilerCompileArg* pArg )
{
    auto codeType = static_cast< nngfxToolShaderCompilerCodeType >( pArg->targetCodeType );
    if( HasSource( codeType ) )
    {
        m_pSourceCompiler.reset( new Compiler< CompilerVariation< static_cast<
            nngfxToolShaderCompilerLowLevelApiType >( nngfxToolShaderCompilerLowLevelApiType_D3d ),
            nngfxToolShaderCompilerCodeType_Source > >() );
        m_pSourceCompiler->Compile( pOutput, pContext, pArg );
    }
}

template<>
void CompilerManager::CompileImpl< static_cast< nngfxToolShaderCompilerLowLevelApiType >(
    nngfxToolShaderCompilerLowLevelApiType_Vk ) >( CompileOutput* pOutput,
    const ShaderCompilerContext* pContext, const nngfxToolShaderCompilerCompileArg* pArg )
{
    auto codeType = static_cast< nngfxToolShaderCompilerCodeType >( pArg->targetCodeType );
    if( HasSource( codeType ) )
    {
        m_pSourceCompiler.reset( new Compiler< CompilerVariation<
            nngfxToolShaderCompilerLowLevelApiType_Gl,
            nngfxToolShaderCompilerCodeType_Source > >() );
        m_pSourceCompiler->Compile( pOutput, pContext, pArg );
    }
    if( HasIr( codeType ) )
    {
        m_pIntermediateCompiler.reset( new Compiler< CompilerVariation< static_cast<
            nngfxToolShaderCompilerLowLevelApiType >( nngfxToolShaderCompilerLowLevelApiType_Vk ),
            nngfxToolShaderCompilerCodeType_Ir > >() );
        m_pIntermediateCompiler->Compile( pOutput, pContext, pArg );
    }

    if ( HasBinary( codeType ) )
    {
        NN_GFXTOOL_THROW( nngfxToolResultCode_InvalidCodeType );
    }
}

void CompilerManager::Compile( CompileOutput* pOutput,
    const ShaderCompilerContext* pContext, const nngfxToolShaderCompilerCompileArg* pArg )
{
    static void (CompilerManager::*s_pCompileFunctions[])( CompileOutput*, const ShaderCompilerContext*,
        const nngfxToolShaderCompilerCompileArg* ) =
    {
        &CompilerManager::CompileImpl< static_cast< nngfxToolShaderCompilerLowLevelApiType >( 0 ) >,
        &CompilerManager::CompileImpl< static_cast< nngfxToolShaderCompilerLowLevelApiType >( 1 ) >,
        &CompilerManager::CompileImpl< static_cast< nngfxToolShaderCompilerLowLevelApiType >( 2 ) >,
        &CompilerManager::CompileImpl< static_cast< nngfxToolShaderCompilerLowLevelApiType >( 3 ) >,
        &CompilerManager::CompileImpl< static_cast< nngfxToolShaderCompilerLowLevelApiType >( 4 ) >
    };

    if( pArg->targetLowLevelApiType < 0 || pArg->targetLowLevelApiType >
        sizeof( s_pCompileFunctions ) / sizeof( *s_pCompileFunctions ) )
    {
        NN_GFXTOOL_THROW( nngfxToolResultCode_InvalidApiType );
    }

    ( this->*s_pCompileFunctions[ pArg->targetLowLevelApiType ] )( pOutput, pContext, pArg );
}

}
}
