﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <memory>

#include <gfxTool_Common.h>

struct nngfxToolShaderCompilerCompileArg;

namespace nn {
namespace gfxTool {

class VariationGrouper;
class VariationConstantSource;
class PreprocessorDefinitionSource;

class VariationManager
{
public:
    VariationManager();

    ~VariationManager();

    void Initialize( const nngfxToolShaderCompilerCompileArg* pArg );

    int GetVariationCount() const
    {
        return m_VariationCount;
    }

    const VariationGrouper* GetVariationConstantGroup( ShaderStage stage ) const
    {
        return m_pVariationConstantGroup[ static_cast< int >( stage ) ].get();
    }

    const VariationGrouper* GetPreprocessorDefinitionGroup( ShaderStage stage ) const
    {
        return m_pPreprocessorDefinitionGroup[ static_cast< int >( stage ) ].get();
    }

    const VariationGrouper* GetVariationGroup( ShaderStage stage ) const
    {
        return m_pVariationGroup[ static_cast< int >( stage ) ].get();
    }

    const VariationGrouper* GetPreprocessorDefinitionGroup() const
    {
        return m_pCombinedPreprocessorDefinitionGroup.get();
    }

    const std::shared_ptr< VariationConstantSource >& GetVariationConstantSource( ShaderStage stage ) const
    {
        return m_pVariationConstantSource[ static_cast< int >( stage ) ];
    }

    const std::shared_ptr< PreprocessorDefinitionSource >& GetPreprocessorDefinitionSource( ShaderStage stage ) const
    {
        return m_pPreprocessorDefinitionSource[ static_cast< int >( stage ) ];
    }

private:
    int m_VariationCount;

    Custom< std::unique_ptr< VariationGrouper > >::Type m_pVariationConstantGroup[ ShaderStage::End ];
    Custom< std::unique_ptr< VariationGrouper > >::Type m_pPreprocessorDefinitionGroup[ ShaderStage::End ];
    Custom< std::unique_ptr< VariationGrouper > >::Type m_pVariationGroup[ ShaderStage::End ];

    Custom< std::unique_ptr< VariationGrouper > >::Type m_pCombinedPreprocessorDefinitionGroup;

    std::shared_ptr< VariationConstantSource > m_pVariationConstantSource[ ShaderStage::End ];
    std::shared_ptr< PreprocessorDefinitionSource > m_pPreprocessorDefinitionSource[ ShaderStage::End ];
};

}
}
