﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <gfxTool_Common.h>
#include <gfxTool_Compiler.h>
#include <gfxTool_ShaderUtilsDll.h>

namespace nn {
namespace gfxTool {

class ProgramOutput;
class VariationOutput;
class CompileOptionManager;

template<>
class Compiler< CompilerVariation< static_cast<
    nngfxToolShaderCompilerLowLevelApiType >( nngfxToolShaderCompilerLowLevelApiType_Gx ),
    nngfxToolShaderCompilerCodeType_Binary > >
    : public CompilerBase
{
public:
    virtual int GetGroupCount( const ShaderCompilerContext* pContext,
        const nngfxToolShaderCompilerCompileArg* pArg ) const override
    {
        NN_UNUSED( pContext );
        return pArg->variationCount;
    }

    virtual void PreCompile( CompileOutput* pOutput,
        const ShaderCompilerContext* pContext, const nngfxToolShaderCompilerCompileArg* pArg ) override;

    virtual void CompileGroup( CompileOutput* pOutput, const ShaderCompilerContext* pContext,
        const nngfxToolShaderCompilerCompileArg* pArg, int idxGroup ) override;

    virtual void PostCompile( CompileOutput* pOutput,
        const ShaderCompilerContext* pContext, const nngfxToolShaderCompilerCompileArg* pArg ) override;

private:
    void CompileGx2( ProgramOutput* pVariationOutput, GSH2Handle handle,
        GSH2CompileSetup3* pCompileSetup3,int codePage, int idxVariation );

    ShaderUtilsDll m_ShaderUtilsDll;
    Custom< std::vector< GSH2Handle > >::Type m_Handles;
    GSH2Options m_Option;
    int m_HandleCountPerVariation;
};

}
}
