﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <memory>
#include <vector>
#include <mutex>

#include <gfxTool_Common.h>
#include <gfxTool_Compiler.h>
#include <gfxTool_GlFunction.h>
#include <gfxTool_GlContext.h>

namespace nn {
namespace gfxTool {

class ProgramOutput;
class OptionOutputReflection;

template<>
class Compiler< CompilerVariation< nngfxToolShaderCompilerLowLevelApiType_Gl,
    nngfxToolShaderCompilerCodeType_Binary > >
    : public CompilerBase
{
public:
    virtual int GetGroupCount( const ShaderCompilerContext* pContext,
        const nngfxToolShaderCompilerCompileArg* pArg ) const override
    {
        NN_UNUSED( pContext );
        return pArg->variationCount;
    }

    virtual void PreCompile( CompileOutput* pOutput,
        const ShaderCompilerContext* pContext, const nngfxToolShaderCompilerCompileArg* pArg ) override;

    virtual void CompileGroup( CompileOutput* pOutput, const ShaderCompilerContext* pContext,
        const nngfxToolShaderCompilerCompileArg* pArg, int idxGroup ) override;

    virtual void PostCompile( CompileOutput* pOutput,
        const ShaderCompilerContext* pContext, const nngfxToolShaderCompilerCompileArg* pArg ) override;

private:
    struct StageIntermediateResult
    {
        GLuint hShader;
        std::shared_ptr< nn::gfxTool::Custom< std::string >::Type > pInfoLog;
        std::vector< const GLchar* > sources;
        std::vector< GLint > lengths;
        Custom< std::string >::Type preprocessedSource;
    };

    void CreateSources( StageIntermediateResult* pResults, const ShaderCompilerContext* pContext,
        const nngfxToolShaderCompilerCompileArg* pArg, int idxVariation );
    void CompileStage( StageIntermediateResult* pResult, const ShaderCompilerContext* pContext,
        const nngfxToolShaderCompilerCompileArg* pArg, ShaderStage stage, int idxVariation );

    Custom< std::vector< char > >::Type GetShaderInfoLog( GLuint hShader );
    Custom< std::vector< char > >::Type GetProgramInfoLog( GLuint hProgram );
    bool CheckShaderStatus( GLuint hShader );
    bool CheckProgramStatus( GLuint hProgram );

    void RetrieveOutput( ProgramOutput* pOutput, GLuint hProgram, ShaderStage stage, bool compress );
    void DumpShaderSource( ProgramOutput* pOutput,
        const StageIntermediateResult* pResult, ShaderStage stage );
    void RetrieveReflection( OptionOutputReflection* pOutput, GLuint hProgram, bool isComputeShader );

    Custom< std::string >::Type CreateErrorSource( ShaderStage stage,
        const StageIntermediateResult* pResult, int codePage );

    Custom< std::unique_ptr< GlContext[] > >::Type m_GlContexts;
    GlFunction m_GlFunction;

    std::mutex m_Mutex;
};

}
}
