﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

template< nngfxToolShaderCompilerOptionType OptionOutputType >
class CompileOption;

class CompileOptionBase
{
public:
    virtual ~CompileOptionBase()
    {
    }

    virtual void Initialize( const void* pOption ) = 0;
};

template<>
class CompileOption< nngfxToolShaderCompilerOptionType_Common >
    : public CompileOptionBase
{
public:
    CompileOption()
        : m_IsDumpEnabled( false )
        , m_PrintProgressRate( 1.0f )
        , m_IsSeparationEnabled( false )
        , m_IsShaderStatisticsEnabled( false )
        , m_IsReflectionEnabled( false )
        , m_IsInvertZEnabled( false )
        , m_IsRemapZEnabled( false )
        , m_IsCompressionEnabled( true )
        , m_UniformRegisterBlockName()
    {
    }

    virtual void Initialize( const void* pOption ) override;

    bool IsDumpEnabled() const
    {
        return m_IsDumpEnabled;
    }

    float GetPrintProgressRate() const
    {
        return m_PrintProgressRate;
    }

    bool IsSeparationEnabled() const
    {
        return m_IsSeparationEnabled;
    }

    bool IsShaderStatisticsEnabled() const
    {
        return m_IsShaderStatisticsEnabled;
    }

    bool IsReflectionEnabled() const
    {
        return m_IsReflectionEnabled;
    }

    bool IsInvertYEnabled() const
    {
        return m_IsInvertZEnabled;
    }

    bool IsRemapZEnabled() const
    {
        return m_IsRemapZEnabled;
    }

    int GetMaxThreads() const
    {
        return m_MaxThreads;
    }

    int GetCodePage() const
    {
        return m_CodePage;
    }

    bool IsCompressionEnabled() const
    {
        return m_IsCompressionEnabled;
    }

    bool IsPreprocessEnabled() const
    {
        return m_IsPreprocessEnabled;
    }

    nngfxToolShaderCompilerDebugInfoLevel GetDebugInfoLevel() const
    {
        return m_DebugInfoLevel;
    }

    const Custom< std::string >::Type GetUniformRegisterBlockName() const
    {
        return m_UniformRegisterBlockName;
    }

    const std::shared_ptr< Custom< std::string >::Type >& GetPreprocessorDefinitionSource() const
    {
        return m_pPreprocessorDefinitionSource;
    }

private:
    bool m_IsDumpEnabled;
    float m_PrintProgressRate;
    bool m_IsSeparationEnabled;
    bool m_IsShaderStatisticsEnabled;
    bool m_IsReflectionEnabled;
    bool m_IsInvertZEnabled;
    bool m_IsRemapZEnabled;
    int m_MaxThreads;
    int m_CodePage;
    bool m_IsCompressionEnabled;
    bool m_IsPreprocessEnabled;
    nngfxToolShaderCompilerDebugInfoLevel m_DebugInfoLevel;
    Custom< std::string >::Type m_UniformRegisterBlockName;

    std::shared_ptr< Custom< std::string >::Type > m_pPreprocessorDefinitionSource;
};

}
}
