/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/
uniform vec2        TextureSize0;
uniform sampler2D   Texture0;


void main()
{
    vec2 vTexOffset_1 = vec2( 1 / TextureSize0.x, 1 / TextureSize0.y );

    vec4 c = vec4( 0, 0, 0, 0 );
    c += texture2D( Texture0, vec2(  vTexOffset_1.x,  vTexOffset_1.y ) + gl_TexCoord[0].st );
    c += texture2D( Texture0, vec2(  vTexOffset_1.x, -vTexOffset_1.y ) + gl_TexCoord[0].st );
    c += texture2D( Texture0, vec2( -vTexOffset_1.x,  vTexOffset_1.y ) + gl_TexCoord[0].st );
    c += texture2D( Texture0, vec2( -vTexOffset_1.x, -vTexOffset_1.y ) + gl_TexCoord[0].st );
    c += texture2D( Texture0, gl_TexCoord[0].st );
    gl_FragColor = c * 0.2;
}
