﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __HIO_H__
#define __HIO_H__

#ifdef WIN32//host include here
#   include <windows.h>
#   include <nw/types.h>
#else
#   include <dolphin/types.h>

#ifndef WINAPI
#   define WINAPI
#endif

#endif

#ifdef __cplusplus
extern "C" {
#endif

#define HIO_STATUS_TX   0x00000001  // Tx mailbox interrupt
#define HIO_STATUS_RX   0x00000002  // Rx mailbox interrupt
#define HIO_STATUS_ID   0x00000004  // ID interrupt

#define HIO_NOTIFY_INIT_REQUEST 0x0001
#define HIO_NOTIFY_EXIT_DONE    0x0002

// CALLBACK PROTOTYPES
// ================
typedef void (WINAPI*HIOCallback)( void /*OSContext* context*/);
typedef BOOL (WINAPI*HIOEnumCallback)( s32 chan );
typedef s32 (WINAPI*HIONotify)( s32 event,void* param );

// FUNCTION PROTOTYPES
// ================
BOOL WINAPI HIOEnumDevices ( HIOEnumCallback callback );
BOOL WINAPI HIOInit        ( s32 chan, HIOCallback callback );
BOOL WINAPI HIOInitEx      ( s32 chan, u32 dev, HIOCallback callback );
BOOL WINAPI HIOReadMailbox ( u32* word );
BOOL WINAPI HIOWriteMailbox( u32  word );
BOOL WINAPI HIORead        ( u32 addr, void* buffer, s32 size );
BOOL WINAPI HIOWrite       ( u32 addr, const void* buffer, s32 size );
BOOL WINAPI HIOReadAsync   ( u32 addr, void* buffer, s32 size, HIOCallback callback );
BOOL WINAPI HIOWriteAsync  ( u32 addr, const void* buffer, s32 size, HIOCallback callback );
BOOL WINAPI HIOReadStatus  ( u32* status );
BOOL WINAPI HIOInit2       ( s32 chan, HIOCallback callback, HIONotify notify, void* param);
BOOL WINAPI HIOInitEx2     ( s32 chan, s32 dev,HIOCallback callback, HIONotify notify,void* param);

#ifdef WIN32
void WINAPI HIOExit ( );
#endif

#ifdef __cplusplus
}
#endif

#endif  // __HIO_H__
