﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Runtime.Remoting.Lifetime;

namespace Nintendo.McsServer
{
    public class ServerControl : MarshalByRefObject
    {
        delegate void DelegateSendAppArgs(string[] args);

        MainForm _mainForm;

        public ServerControl(){}

        public void SetMainForm(MainForm mainForm)
        {
            _mainForm = mainForm;
        }

        public void SendAppArgs(string[] args)
        {
            Debug.Assert(_mainForm != null);

            _mainForm.Invoke(new DelegateSendAppArgs(_mainForm.DoSendAppArgs), new object[] { args });
        }

        public override Object InitializeLifetimeService()
        {
            ILease lease = (ILease)base.InitializeLifetimeService();
            if (lease.CurrentState == LeaseState.Initial)
            {
                lease.InitialLeaseTime = TimeSpan.Zero; // 寿命を無限にする。
            }
            return lease;
        }
    }
}
