﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;
using System.Drawing;

namespace Nintendo.McsServer
{
    public enum ServerReportType
    {
        Report,
        Error,
        InternalError
    }

    internal delegate void DelegateServerReport();

    /// <summary>
    /// MCSサーバーのテキスト表示エリア等にログ文字列を出力するクラス。
    /// </summary>
    internal class Reporter
    {
        /// <summary>
        ///
        /// </summary>
        const int MaxTextLength = 64 * 1024;
        /// <summary>
        ///
        /// </summary>
        readonly string _appendText;
        /// <summary>
        ///
        /// </summary>
        readonly ServerReportType _reportType;

        /// <summary>
        ///
        /// </summary>
        internal Reporter( string appendText, ServerReportType reportType )
        {
            _appendText = appendText;
            _reportType = reportType;
        }

        /// <summary>
        ///
        /// </summary>
        internal void DoReport(
            object      sender,
            EventArgs   e
        )
        {
            RichTextBox richTextBox = (RichTextBox)sender;
            if (richTextBox.IsDisposed)
            {
                return;
            }

            bool bReadOnly = richTextBox.ReadOnly;
            richTextBox.ReadOnly = false;
            if (richTextBox.TextLength + _appendText.Length > MaxTextLength)
            {
                if (_appendText.Length > MaxTextLength)
                {
                    _appendText.Remove(0, _appendText.Length - MaxTextLength);
                    richTextBox.Clear();
                }
                else
                {
                    richTextBox.Select(0, richTextBox.TextLength + _appendText.Length - MaxTextLength);
                    richTextBox.SelectedText = string.Empty;
                }
            }

            richTextBox.Select(richTextBox.TextLength, 0);
            Color color = Color.Green;
            if (_reportType == ServerReportType.Error)
            {
                color = Color.Red;
            }
            else if (_reportType == ServerReportType.InternalError)
            {
                color = Color.Gray;
            }
            richTextBox.SelectionColor = color;
            richTextBox.SelectedText = _appendText + "\n";
            richTextBox.SelectionColor = richTextBox.ForeColor;
            richTextBox.ReadOnly = bReadOnly;
        }
    }

    /// <summary>
    /// MCSサーバーのテキスト表示エリア等にログ文字列を出力するクラス。
    /// </summary>
    public class RouterLog
    {
        /// <summary>
        ///
        /// </summary>
        static RichTextBox _sRichTextBox;

        /// <summary>
        ///
        /// </summary>
        public static void SetRichTextBox( RichTextBox textBox )
        {
            lock (typeof(RouterLog))
            {
                _sRichTextBox = textBox;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public static void ServerReport( string format, params object[] args )
        {
            ServerReport(ServerReportType.Report, format, args);
        }

        /// <summary>
        ///
        /// </summary>
        public static void ServerReport(ServerReportType reportType, string format, params object[] args)
        {
            lock (typeof(RouterLog))
            {
                if (_sRichTextBox == null)
                {
                    return;
                }

                Reporter reporter = new Reporter(string.Format(format, args), reportType);
                _sRichTextBox.BeginInvoke(new EventHandler(reporter.DoReport));
            }
        }
    }
}
