﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;

namespace Nintendo.McsServer
{
    public partial class EnvVarForm : Form
    {
        private string editingValue;

        List<string> _modifiedEnvVar = null;

        private enum Colmn
        {
            KEY = 0,
            VALUE,
            NUM
        }

        public EnvVarForm(List<string> modifiedEnvVar)
        {
            _modifiedEnvVar = modifiedEnvVar;
            InitializeComponent();

            Icon = MainForm.GetApplicationIcon();   // フォームのアイコン設定
        }

        private void dataGridView1_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
        }

        private void EnvVarForm_Load(object sender, EventArgs e)
        {
            this.dataGrid.Rows.Clear();
            foreach (DictionaryEntry env in Environment.GetEnvironmentVariables())
            {
                Object[] values = new Object[(int)Colmn.NUM];
                values[(int)Colmn.KEY] = env.Key;
                values[(int)Colmn.VALUE] = env.Value;
                this.dataGrid.Rows.Add(values);
            }

            this.dataGrid.Sort(this.dataGrid.Columns[0], ListSortDirection.Ascending);

            foreach (DataGridViewRow row in this.dataGrid.Rows)
            {
                DataGridViewTextBoxCell keyCell = row.Cells[(int)Colmn.KEY] as DataGridViewTextBoxCell;
                DataGridViewTextBoxCell valueCell = row.Cells[(int)Colmn.VALUE] as DataGridViewTextBoxCell;

                if (_modifiedEnvVar.Contains((string)keyCell.Value))
                {
                    keyCell.Style.ForeColor = System.Drawing.Color.Red;
                    valueCell.Style.ForeColor = System.Drawing.Color.Red;
                    keyCell.Style.SelectionForeColor = System.Drawing.Color.Red;
                    valueCell.Style.SelectionForeColor = System.Drawing.Color.Red;
                }
            }
        }

        /// <summary>
        /// セルの編集開始時の処理
        /// </summary>
        private void dataGrid_CellBeginEdit(object sender, DataGridViewCellCancelEventArgs e)
        {
            DataGridView dgv = sender as DataGridView;
            if (e.ColumnIndex < 0 || e.RowIndex < 0) { return; }

            DataGridViewTextBoxCell valueCell = dgv[1, e.RowIndex] as DataGridViewTextBoxCell;

            // 編集前の値を覚えておく
            this.editingValue = "";
            if (valueCell != null)
            {
                this.editingValue = (string)valueCell.Value;
            }

        }

        /// <summary>
        /// セルの編集完了時の処理
        /// </summary>
        private void dataGrid_CellEndEdit(object sender, DataGridViewCellEventArgs e)
        {
            DataGridView dgv = sender as DataGridView;
            if (e.ColumnIndex < 0 || e.RowIndex < 0) { return; }

            DataGridViewTextBoxCell keyCell = dgv[0, e.RowIndex] as DataGridViewTextBoxCell;
            DataGridViewTextBoxCell valueCell = dgv[1, e.RowIndex] as DataGridViewTextBoxCell;

            if (keyCell == null || valueCell == null)
            {
                return;
            }

            if (this.editingValue != (string)valueCell.Value)
            {
                Environment.SetEnvironmentVariable((string)keyCell.Value, (string)valueCell.Value);
                keyCell.Style.ForeColor = System.Drawing.Color.Red;
                valueCell.Style.ForeColor = System.Drawing.Color.Red;
                keyCell.Style.SelectionForeColor = System.Drawing.Color.Red;
                valueCell.Style.SelectionForeColor = System.Drawing.Color.Red;

                if (!_modifiedEnvVar.Contains((string)keyCell.Value))
                {
                    _modifiedEnvVar.Add((string)keyCell.Value);
                }
            }
        }
    }
}
